@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getExperience.
 * @property arn ARN of the Experience.
 * @property configurations Block that specifies the configuration information for your Amazon Kendra Experience. This includes `content_source_configuration`, which specifies the data source IDs and/or FAQ IDs, and `user_identity_configuration`, which specifies the user or group information to grant access to your Amazon Kendra Experience. Documented below.
 * @property createdAt Unix datetime that the Experience was created.
 * @property description Description of the Experience.
 * @property endpoints Shows the endpoint URLs for your Amazon Kendra Experiences. The URLs are unique and fully hosted by AWS. Documented below.
 * @property errorMessage Reason your Amazon Kendra Experience could not properly process.
 * @property experienceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property indexId
 * @property name Name of the Experience.
 * @property roleArn Shows the ARN of a role with permission to access `Query` API, `QuerySuggestions` API, `SubmitFeedback` API, and AWS SSO that stores your user and group information.
 * @property status Current processing status of your Amazon Kendra Experience. When the status is `ACTIVE`, your Amazon Kendra Experience is ready to use. When the status is `FAILED`, the `error_message` field contains the reason that this failed.
 * @property updatedAt Date and time that the Experience was last updated.
 */
public data class GetExperienceResult(
    public val arn: String,
    public val configurations: List<GetExperienceConfiguration>,
    public val createdAt: String,
    public val description: String,
    public val endpoints: List<GetExperienceEndpoint>,
    public val errorMessage: String,
    public val experienceId: String,
    public val id: String,
    public val indexId: String,
    public val name: String,
    public val roleArn: String,
    public val status: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetExperienceResult):
            GetExperienceResult = GetExperienceResult(
            arn = javaType.arn(),
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetExperienceConfiguration.Companion.toKotlin(args0)
                })
            }),
            createdAt = javaType.createdAt(),
            description = javaType.description(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetExperienceEndpoint.Companion.toKotlin(args0)
                })
            }),
            errorMessage = javaType.errorMessage(),
            experienceId = javaType.experienceId(),
            id = javaType.id(),
            indexId = javaType.indexId(),
            name = javaType.name(),
            roleArn = javaType.roleArn(),
            status = javaType.status(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
