@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFaq.
 * @property arn ARN of the FAQ.
 * @property createdAt Unix datetime that the faq was created.
 * @property description Description of the FAQ.
 * @property errorMessage When the `status` field value is `FAILED`, this contains a message that explains why.
 * @property faqId
 * @property fileFormat File format used by the input files for the FAQ. Valid Values are `CSV`, `CSV_WITH_HEADER`, `JSON`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property indexId
 * @property languageCode Code for a language. This shows a supported language for the FAQ document. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
 * @property name Name of the FAQ.
 * @property roleArn ARN of a role with permission to access the S3 bucket that contains the FAQs. For more information, see [IAM Roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
 * @property s3Paths S3 location of the FAQ input data. Detailed below.
 * @property status Status of the FAQ. It is ready to use when the status is ACTIVE.
 * @property tags Metadata that helps organize the FAQs you create.
 * @property updatedAt Date and time that the FAQ was last updated.
 */
public data class GetFaqResult(
    public val arn: String,
    public val createdAt: String,
    public val description: String,
    public val errorMessage: String,
    public val faqId: String,
    public val fileFormat: String,
    public val id: String,
    public val indexId: String,
    public val languageCode: String,
    public val name: String,
    public val roleArn: String,
    public val s3Paths: List<GetFaqS3Path>,
    public val status: String,
    public val tags: Map<String, String>,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetFaqResult): GetFaqResult =
            GetFaqResult(
                arn = javaType.arn(),
                createdAt = javaType.createdAt(),
                description = javaType.description(),
                errorMessage = javaType.errorMessage(),
                faqId = javaType.faqId(),
                fileFormat = javaType.fileFormat(),
                id = javaType.id(),
                indexId = javaType.indexId(),
                languageCode = javaType.languageCode(),
                name = javaType.name(),
                roleArn = javaType.roleArn(),
                s3Paths = javaType.s3Paths().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetFaqS3Path.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                updatedAt = javaType.updatedAt(),
            )
    }
}
