@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property duration Time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Duration).
 * @property freshness How "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Freshness).
 * @property importance Relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
 * @property rankOrder Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
 * @property valuesImportanceMap A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
 */
public data class GetIndexDocumentMetadataConfigurationUpdateRelevance(
    public val duration: String,
    public val freshness: Boolean,
    public val importance: Int,
    public val rankOrder: String,
    public val valuesImportanceMap: Map<String, Int>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexDocumentMetadataConfigurationUpdateRelevance):
            GetIndexDocumentMetadataConfigurationUpdateRelevance =
            GetIndexDocumentMetadataConfigurationUpdateRelevance(
                duration = javaType.duration(),
                freshness = javaType.freshness(),
                importance = javaType.importance(),
                rankOrder = javaType.rankOrder(),
                valuesImportanceMap = javaType.valuesImportanceMap().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
            )
    }
}
