@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property faqStatistics Block that specifies the number of question and answer topics in the index. Documented below.
 * @property textDocumentStatistics A block that specifies the number of text documents indexed.
 */
public data class GetIndexIndexStatistic(
    public val faqStatistics: List<GetIndexIndexStatisticFaqStatistic>,
    public val textDocumentStatistics: List<GetIndexIndexStatisticTextDocumentStatistic>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexIndexStatistic):
            GetIndexIndexStatistic = GetIndexIndexStatistic(
            faqStatistics = javaType.faqStatistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexIndexStatisticFaqStatistic.Companion.toKotlin(args0)
                })
            }),
            textDocumentStatistics = javaType.textDocumentStatistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.GetIndexIndexStatisticTextDocumentStatistic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
