@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getIndex.
 * @property arn ARN of the Index.
 * @property capacityUnits Block that sets the number of additional document storage and query capacity units that should be used by the index. Documented below.
 * @property createdAt Unix datetime that the index was created.
 * @property description Description of the Index.
 * @property documentMetadataConfigurationUpdates One or more blocks that specify the configuration settings for any metadata applied to the documents in the index. Documented below.
 * @property edition Amazon Kendra edition for the index.
 * @property errorMessage When the Status field value is `FAILED`, this contains a message that explains why.
 * @property id Identifier of the Index.
 * @property indexStatistics Block that provides information about the number of FAQ questions and answers and the number of text documents indexed. Documented below.
 * @property name Name of the index field. Minimum length of 1. Maximum length of 30.
 * @property roleArn An AWS Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
 * @property serverSideEncryptionConfigurations A block that specifies the identifier of the AWS KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs. Documented below.
 * @property status Current status of the index. When the value is `ACTIVE`, the index is ready for use. If the Status field value is `FAILED`, the `error_message` field contains a message that explains why.
 * @property tags Metadata that helps organize the Indices you create.
 * @property updatedAt Unix datetime that the index was last updated.
 * @property userContextPolicy User context policy. Valid values are `ATTRIBUTE_FILTER` or `USER_TOKEN`. For more information, refer to [UserContextPolicy](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CreateIndex.html#kendra-CreateIndex-request-UserContextPolicy).
 * @property userGroupResolutionConfigurations A block that enables fetching access levels of groups and users from an AWS Single Sign-On identity source. Documented below.
 * @property userTokenConfigurations A block that specifies the user token configuration. Documented below.
 */
public data class GetIndexResult(
    public val arn: String,
    public val capacityUnits: List<GetIndexCapacityUnit>,
    public val createdAt: String,
    public val description: String,
    public val documentMetadataConfigurationUpdates:
    List<GetIndexDocumentMetadataConfigurationUpdate>,
    public val edition: String,
    public val errorMessage: String,
    public val id: String,
    public val indexStatistics: List<GetIndexIndexStatistic>,
    public val name: String,
    public val roleArn: String,
    public val serverSideEncryptionConfigurations: List<GetIndexServerSideEncryptionConfiguration>,
    public val status: String,
    public val tags: Map<String, String>,
    public val updatedAt: String,
    public val userContextPolicy: String,
    public val userGroupResolutionConfigurations: List<GetIndexUserGroupResolutionConfiguration>,
    public val userTokenConfigurations: List<GetIndexUserTokenConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.GetIndexResult): GetIndexResult =
            GetIndexResult(
                arn = javaType.arn(),
                capacityUnits = javaType.capacityUnits().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexCapacityUnit.Companion.toKotlin(args0)
                    })
                }),
                createdAt = javaType.createdAt(),
                description = javaType.description(),
                documentMetadataConfigurationUpdates = javaType.documentMetadataConfigurationUpdates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexDocumentMetadataConfigurationUpdate.Companion.toKotlin(args0)
                    })
                }),
                edition = javaType.edition(),
                errorMessage = javaType.errorMessage(),
                id = javaType.id(),
                indexStatistics = javaType.indexStatistics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexIndexStatistic.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                roleArn = javaType.roleArn(),
                serverSideEncryptionConfigurations = javaType.serverSideEncryptionConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexServerSideEncryptionConfiguration.Companion.toKotlin(args0)
                    })
                }),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                updatedAt = javaType.updatedAt(),
                userContextPolicy = javaType.userContextPolicy(),
                userGroupResolutionConfigurations = javaType.userGroupResolutionConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexUserGroupResolutionConfiguration.Companion.toKotlin(args0)
                    })
                }),
                userTokenConfigurations = javaType.userTokenConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kendra.kotlin.outputs.GetIndexUserTokenConfiguration.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
