@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the index field. Minimum length of 1. Maximum length of 30.
 * @property relevance A block that provides manual tuning parameters to determine how the field affects the search results. Detailed below
 * @property search A block that provides information about how the field is used during a search. Documented below. Detailed below
 * @property type The data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
 */
public data class IndexDocumentMetadataConfigurationUpdate(
    public val name: String,
    public val relevance: IndexDocumentMetadataConfigurationUpdateRelevance? = null,
    public val search: IndexDocumentMetadataConfigurationUpdateSearch? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexDocumentMetadataConfigurationUpdate):
            IndexDocumentMetadataConfigurationUpdate = IndexDocumentMetadataConfigurationUpdate(
            name = javaType.name(),
            relevance = javaType.relevance().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexDocumentMetadataConfigurationUpdateRelevance.Companion.toKotlin(args0)
                })
            }).orElse(null),
            search = javaType.search().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexDocumentMetadataConfigurationUpdateSearch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
