@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property displayable Determines whether the field is returned in the query response. The default is `true`.
 * @property facetable Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
 * @property searchable Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
 * @property sortable Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
 */
public data class IndexDocumentMetadataConfigurationUpdateSearch(
    public val displayable: Boolean? = null,
    public val facetable: Boolean? = null,
    public val searchable: Boolean? = null,
    public val sortable: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexDocumentMetadataConfigurationUpdateSearch):
            IndexDocumentMetadataConfigurationUpdateSearch =
            IndexDocumentMetadataConfigurationUpdateSearch(
                displayable = javaType.displayable().map({ args0 -> args0 }).orElse(null),
                facetable = javaType.facetable().map({ args0 -> args0 }).orElse(null),
                searchable = javaType.searchable().map({ args0 -> args0 }).orElse(null),
                sortable = javaType.sortable().map({ args0 -> args0 }).orElse(null),
            )
    }
}
