@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property faqStatistics A block that specifies the number of question and answer topics in the index. Detailed below.
 * @property textDocumentStatistics A block that specifies the number of text documents indexed. Detailed below.
 */
public data class IndexIndexStatistic(
    public val faqStatistics: List<IndexIndexStatisticFaqStatistic>? = null,
    public val textDocumentStatistics: List<IndexIndexStatisticTextDocumentStatistic>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexIndexStatistic):
            IndexIndexStatistic = IndexIndexStatistic(
            faqStatistics = javaType.faqStatistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexIndexStatisticFaqStatistic.Companion.toKotlin(args0)
                })
            }),
            textDocumentStatistics = javaType.textDocumentStatistics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexIndexStatisticTextDocumentStatistic.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
