@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property indexedTextBytes The total size, in bytes, of the indexed documents.
 * @property indexedTextDocumentsCount The number of text documents indexed.
 */
public data class IndexIndexStatisticTextDocumentStatistic(
    public val indexedTextBytes: Int? = null,
    public val indexedTextDocumentsCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexIndexStatisticTextDocumentStatistic):
            IndexIndexStatisticTextDocumentStatistic = IndexIndexStatisticTextDocumentStatistic(
            indexedTextBytes = javaType.indexedTextBytes().map({ args0 -> args0 }).orElse(null),
            indexedTextDocumentsCount = javaType.indexedTextDocumentsCount().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
