@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
 */
public data class IndexServerSideEncryptionConfiguration(
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexServerSideEncryptionConfiguration):
            IndexServerSideEncryptionConfiguration = IndexServerSideEncryptionConfiguration(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
