@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property userGroupResolutionMode The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
 */
public data class IndexUserGroupResolutionConfiguration(
    public val userGroupResolutionMode: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexUserGroupResolutionConfiguration):
            IndexUserGroupResolutionConfiguration = IndexUserGroupResolutionConfiguration(
            userGroupResolutionMode = javaType.userGroupResolutionMode(),
        )
    }
}
