@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property jsonTokenTypeConfiguration A block that specifies the information about the JSON token type configuration. Detailed below.
 * @property jwtTokenTypeConfiguration A block that specifies the information about the JWT token type configuration. Detailed below.
 */
public data class IndexUserTokenConfigurations(
    public val jsonTokenTypeConfiguration: IndexUserTokenConfigurationsJsonTokenTypeConfiguration? =
        null,
    public val jwtTokenTypeConfiguration: IndexUserTokenConfigurationsJwtTokenTypeConfiguration? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexUserTokenConfigurations):
            IndexUserTokenConfigurations = IndexUserTokenConfigurations(
            jsonTokenTypeConfiguration = javaType.jsonTokenTypeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexUserTokenConfigurationsJsonTokenTypeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jwtTokenTypeConfiguration = javaType.jwtTokenTypeConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kendra.kotlin.outputs.IndexUserTokenConfigurationsJwtTokenTypeConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
