@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kendra.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property claimRegex The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
 * @property groupAttributeField The group attribute field. Minimum length of 1. Maximum length of 100.
 * @property issuer The issuer of the token. Minimum length of 1. Maximum length of 65.
 * @property keyLocation The location of the key. Valid values are `URL` or `SECRET_MANAGER`
 * @property secretsManagerArn The Amazon Resource Name (ARN) of the secret.
 * @property url The signing key URL. Valid pattern is `^(https?|ftp|file):\/\/([^\s]*)`
 * @property userNameAttributeField The user name attribute field. Minimum length of 1. Maximum length of 100.
 */
public data class IndexUserTokenConfigurationsJwtTokenTypeConfiguration(
    public val claimRegex: String? = null,
    public val groupAttributeField: String? = null,
    public val issuer: String? = null,
    public val keyLocation: String,
    public val secretsManagerArn: String? = null,
    public val url: String? = null,
    public val userNameAttributeField: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.kendra.outputs.IndexUserTokenConfigurationsJwtTokenTypeConfiguration):
            IndexUserTokenConfigurationsJwtTokenTypeConfiguration =
            IndexUserTokenConfigurationsJwtTokenTypeConfiguration(
                claimRegex = javaType.claimRegex().map({ args0 -> args0 }).orElse(null),
                groupAttributeField = javaType.groupAttributeField().map({ args0 -> args0 }).orElse(null),
                issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
                keyLocation = javaType.keyLocation(),
                secretsManagerArn = javaType.secretsManagerArn().map({ args0 -> args0 }).orElse(null),
                url = javaType.url().map({ args0 -> args0 }).orElse(null),
                userNameAttributeField = javaType.userNameAttributeField().map({ args0 -> args0 }).orElse(null),
            )
    }
}
