@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableCapacitySpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property readCapacityUnits The throughput capacity specified for read operations defined in read capacity units (RCUs).
 * @property throughputMode The read/write throughput capacity mode for a table. Valid values: `PAY_PER_REQUEST`, `PROVISIONED`. The default value is `PAY_PER_REQUEST`.
 * @property writeCapacityUnits The throughput capacity specified for write operations defined in write capacity units (WCUs).
 */
public data class TableCapacitySpecificationArgs(
    public val readCapacityUnits: Output<Int>? = null,
    public val throughputMode: Output<String>? = null,
    public val writeCapacityUnits: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableCapacitySpecificationArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableCapacitySpecificationArgs =
        com.pulumi.aws.keyspaces.inputs.TableCapacitySpecificationArgs.builder()
            .readCapacityUnits(readCapacityUnits?.applyValue({ args0 -> args0 }))
            .throughputMode(throughputMode?.applyValue({ args0 -> args0 }))
            .writeCapacityUnits(writeCapacityUnits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableCapacitySpecificationArgs].
 */
@PulumiTagMarker
public class TableCapacitySpecificationArgsBuilder internal constructor() {
    private var readCapacityUnits: Output<Int>? = null

    private var throughputMode: Output<String>? = null

    private var writeCapacityUnits: Output<Int>? = null

    /**
     * @param value The throughput capacity specified for read operations defined in read capacity units (RCUs).
     */
    @JvmName("vuouagkwajhbuukd")
    public suspend fun readCapacityUnits(`value`: Output<Int>) {
        this.readCapacityUnits = value
    }

    /**
     * @param value The read/write throughput capacity mode for a table. Valid values: `PAY_PER_REQUEST`, `PROVISIONED`. The default value is `PAY_PER_REQUEST`.
     */
    @JvmName("mpqxtaathnasxwdr")
    public suspend fun throughputMode(`value`: Output<String>) {
        this.throughputMode = value
    }

    /**
     * @param value The throughput capacity specified for write operations defined in write capacity units (WCUs).
     */
    @JvmName("ijdvnhralysgbutu")
    public suspend fun writeCapacityUnits(`value`: Output<Int>) {
        this.writeCapacityUnits = value
    }

    /**
     * @param value The throughput capacity specified for read operations defined in read capacity units (RCUs).
     */
    @JvmName("lmhoslbrnsqpvyus")
    public suspend fun readCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readCapacityUnits = mapped
    }

    /**
     * @param value The read/write throughput capacity mode for a table. Valid values: `PAY_PER_REQUEST`, `PROVISIONED`. The default value is `PAY_PER_REQUEST`.
     */
    @JvmName("bhncpxnhibiadcgi")
    public suspend fun throughputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMode = mapped
    }

    /**
     * @param value The throughput capacity specified for write operations defined in write capacity units (WCUs).
     */
    @JvmName("ihjmlysixgpvtyge")
    public suspend fun writeCapacityUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeCapacityUnits = mapped
    }

    internal fun build(): TableCapacitySpecificationArgs = TableCapacitySpecificationArgs(
        readCapacityUnits = readCapacityUnits,
        throughputMode = throughputMode,
        writeCapacityUnits = writeCapacityUnits,
    )
}
