@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableClientSideTimestampsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Shows how to enable client-side timestamps settings for the specified table. Valid values: `ENABLED`.
 */
public data class TableClientSideTimestampsArgs(
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableClientSideTimestampsArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableClientSideTimestampsArgs =
        com.pulumi.aws.keyspaces.inputs.TableClientSideTimestampsArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableClientSideTimestampsArgs].
 */
@PulumiTagMarker
public class TableClientSideTimestampsArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Shows how to enable client-side timestamps settings for the specified table. Valid values: `ENABLED`.
     */
    @JvmName("edkfgdlobpukqyie")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Shows how to enable client-side timestamps settings for the specified table. Valid values: `ENABLED`.
     */
    @JvmName("uiotxrljvtcjevcb")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): TableClientSideTimestampsArgs = TableClientSideTimestampsArgs(
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
