@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableCommentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property message A description of the table.
 */
public data class TableCommentArgs(
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableCommentArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableCommentArgs =
        com.pulumi.aws.keyspaces.inputs.TableCommentArgs.builder()
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableCommentArgs].
 */
@PulumiTagMarker
public class TableCommentArgsBuilder internal constructor() {
    private var message: Output<String>? = null

    /**
     * @param value A description of the table.
     */
    @JvmName("yuxlsoiryywvjlrx")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value A description of the table.
     */
    @JvmName("urkhsjwmhqytghba")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): TableCommentArgs = TableCommentArgs(
        message = message,
    )
}
