@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TablePointInTimeRecoveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Valid values: `ENABLED`, `DISABLED`. The default value is `DISABLED`.
 */
public data class TablePointInTimeRecoveryArgs(
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TablePointInTimeRecoveryArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TablePointInTimeRecoveryArgs =
        com.pulumi.aws.keyspaces.inputs.TablePointInTimeRecoveryArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TablePointInTimeRecoveryArgs].
 */
@PulumiTagMarker
public class TablePointInTimeRecoveryArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Valid values: `ENABLED`, `DISABLED`. The default value is `DISABLED`.
     */
    @JvmName("mbabapblaibfbihy")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Valid values: `ENABLED`, `DISABLED`. The default value is `DISABLED`.
     */
    @JvmName("igfbwewghqfjohdk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): TablePointInTimeRecoveryArgs = TablePointInTimeRecoveryArgs(
        status = status,
    )
}
