@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clusteringKeys The columns that are part of the clustering key of the table.
 * @property columns The regular columns of the table.
 * @property partitionKeys The columns that are part of the partition key of the table .
 * @property staticColumns The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
 */
public data class TableSchemaDefinitionArgs(
    public val clusteringKeys: Output<List<TableSchemaDefinitionClusteringKeyArgs>>? = null,
    public val columns: Output<List<TableSchemaDefinitionColumnArgs>>,
    public val partitionKeys: Output<List<TableSchemaDefinitionPartitionKeyArgs>>,
    public val staticColumns: Output<List<TableSchemaDefinitionStaticColumnArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs =
        com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionArgs.builder()
            .clusteringKeys(
                clusteringKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .columns(
                columns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .partitionKeys(
                partitionKeys.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .staticColumns(
                staticColumns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TableSchemaDefinitionArgs].
 */
@PulumiTagMarker
public class TableSchemaDefinitionArgsBuilder internal constructor() {
    private var clusteringKeys: Output<List<TableSchemaDefinitionClusteringKeyArgs>>? = null

    private var columns: Output<List<TableSchemaDefinitionColumnArgs>>? = null

    private var partitionKeys: Output<List<TableSchemaDefinitionPartitionKeyArgs>>? = null

    private var staticColumns: Output<List<TableSchemaDefinitionStaticColumnArgs>>? = null

    /**
     * @param value The columns that are part of the clustering key of the table.
     */
    @JvmName("sljlaibkxechogwi")
    public suspend fun clusteringKeys(`value`: Output<List<TableSchemaDefinitionClusteringKeyArgs>>) {
        this.clusteringKeys = value
    }

    @JvmName("cuxxptgephavowfj")
    public suspend fun clusteringKeys(vararg values: Output<TableSchemaDefinitionClusteringKeyArgs>) {
        this.clusteringKeys = Output.all(values.asList())
    }

    /**
     * @param values The columns that are part of the clustering key of the table.
     */
    @JvmName("rpykpgwbeqiksowk")
    public suspend fun clusteringKeys(values: List<Output<TableSchemaDefinitionClusteringKeyArgs>>) {
        this.clusteringKeys = Output.all(values)
    }

    /**
     * @param value The regular columns of the table.
     */
    @JvmName("hoypwpxfbfujkugi")
    public suspend fun columns(`value`: Output<List<TableSchemaDefinitionColumnArgs>>) {
        this.columns = value
    }

    @JvmName("xdrwwpiqpvflpvon")
    public suspend fun columns(vararg values: Output<TableSchemaDefinitionColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values The regular columns of the table.
     */
    @JvmName("vyusiojdfaudndam")
    public suspend fun columns(values: List<Output<TableSchemaDefinitionColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value The columns that are part of the partition key of the table .
     */
    @JvmName("cvnuqasxaqwhxlan")
    public suspend fun partitionKeys(`value`: Output<List<TableSchemaDefinitionPartitionKeyArgs>>) {
        this.partitionKeys = value
    }

    @JvmName("kbjmbaqqioycadur")
    public suspend fun partitionKeys(vararg values: Output<TableSchemaDefinitionPartitionKeyArgs>) {
        this.partitionKeys = Output.all(values.asList())
    }

    /**
     * @param values The columns that are part of the partition key of the table .
     */
    @JvmName("dlnmxiimwfrmmppg")
    public suspend fun partitionKeys(values: List<Output<TableSchemaDefinitionPartitionKeyArgs>>) {
        this.partitionKeys = Output.all(values)
    }

    /**
     * @param value The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("yavjoxjakfoaaqwx")
    public suspend fun staticColumns(`value`: Output<List<TableSchemaDefinitionStaticColumnArgs>>) {
        this.staticColumns = value
    }

    @JvmName("osqykugqbbubjkdy")
    public suspend fun staticColumns(vararg values: Output<TableSchemaDefinitionStaticColumnArgs>) {
        this.staticColumns = Output.all(values.asList())
    }

    /**
     * @param values The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("wfqivonecoevjgte")
    public suspend fun staticColumns(values: List<Output<TableSchemaDefinitionStaticColumnArgs>>) {
        this.staticColumns = Output.all(values)
    }

    /**
     * @param value The columns that are part of the clustering key of the table.
     */
    @JvmName("xjohwmpjysqrllan")
    public suspend fun clusteringKeys(`value`: List<TableSchemaDefinitionClusteringKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("butxspdquxworqng")
    public suspend
    fun clusteringKeys(argument: List<suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("muvspyrgeradykla")
    public suspend fun clusteringKeys(
        vararg
        argument: suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param argument The columns that are part of the clustering key of the table.
     */
    @JvmName("ggxgdnxcageyuxwe")
    public suspend
    fun clusteringKeys(argument: suspend TableSchemaDefinitionClusteringKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionClusteringKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.clusteringKeys = mapped
    }

    /**
     * @param values The columns that are part of the clustering key of the table.
     */
    @JvmName("mscegdokgcinambl")
    public suspend fun clusteringKeys(vararg values: TableSchemaDefinitionClusteringKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusteringKeys = mapped
    }

    /**
     * @param value The regular columns of the table.
     */
    @JvmName("tlyyijwoiksnvsdr")
    public suspend fun columns(`value`: List<TableSchemaDefinitionColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("vioegitnxjsuvpxl")
    public suspend
    fun columns(argument: List<suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("huiwcwwsfgsenifg")
    public suspend fun columns(
        vararg
        argument: suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument The regular columns of the table.
     */
    @JvmName("nwoyluhgixnwqnsf")
    public suspend fun columns(argument: suspend TableSchemaDefinitionColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values The regular columns of the table.
     */
    @JvmName("khqmohqapscyuggu")
    public suspend fun columns(vararg values: TableSchemaDefinitionColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value The columns that are part of the partition key of the table .
     */
    @JvmName("nrbbggatcmdkuxxs")
    public suspend fun partitionKeys(`value`: List<TableSchemaDefinitionPartitionKeyArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("hnirdtpltqbspiiq")
    public suspend
    fun partitionKeys(argument: List<suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("qquixytamsaovfbq")
    public suspend fun partitionKeys(
        vararg
        argument: suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param argument The columns that are part of the partition key of the table .
     */
    @JvmName("gsabjkeivljgwovi")
    public suspend
    fun partitionKeys(argument: suspend TableSchemaDefinitionPartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionPartitionKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.partitionKeys = mapped
    }

    /**
     * @param values The columns that are part of the partition key of the table .
     */
    @JvmName("ltjyfurxlxtimscn")
    public suspend fun partitionKeys(vararg values: TableSchemaDefinitionPartitionKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKeys = mapped
    }

    /**
     * @param value The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("vxwlipgophdywnrc")
    public suspend fun staticColumns(`value`: List<TableSchemaDefinitionStaticColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("anrlbrbhqvfwhbbm")
    public suspend
    fun staticColumns(argument: List<suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("kxcxyjdqywrgitfd")
    public suspend fun staticColumns(
        vararg
        argument: suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param argument The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("yauagklxeniweuey")
    public suspend
    fun staticColumns(argument: suspend TableSchemaDefinitionStaticColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TableSchemaDefinitionStaticColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.staticColumns = mapped
    }

    /**
     * @param values The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
     */
    @JvmName("yqgypwlhkxwuxyyn")
    public suspend fun staticColumns(vararg values: TableSchemaDefinitionStaticColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticColumns = mapped
    }

    internal fun build(): TableSchemaDefinitionArgs = TableSchemaDefinitionArgs(
        clusteringKeys = clusteringKeys,
        columns = columns ?: throw PulumiNullFieldException("columns"),
        partitionKeys = partitionKeys ?: throw PulumiNullFieldException("partitionKeys"),
        staticColumns = staticColumns,
    )
}
