@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.inputs

import com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionStaticColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the static column.
 */
public data class TableSchemaDefinitionStaticColumnArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionStaticColumnArgs> {
    override fun toJava(): com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionStaticColumnArgs =
        com.pulumi.aws.keyspaces.inputs.TableSchemaDefinitionStaticColumnArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSchemaDefinitionStaticColumnArgs].
 */
@PulumiTagMarker
public class TableSchemaDefinitionStaticColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the static column.
     */
    @JvmName("xrjxbvndcofgudob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the static column.
     */
    @JvmName("yjwnwfjgypnhwwsy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TableSchemaDefinitionStaticColumnArgs =
        TableSchemaDefinitionStaticColumnArgs(
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
