@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.keyspaces.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusteringKeys The columns that are part of the clustering key of the table.
 * @property columns The regular columns of the table.
 * @property partitionKeys The columns that are part of the partition key of the table .
 * @property staticColumns The columns that have been defined as `STATIC`. Static columns store values that are shared by all rows in the same partition.
 */
public data class TableSchemaDefinition(
    public val clusteringKeys: List<TableSchemaDefinitionClusteringKey>? = null,
    public val columns: List<TableSchemaDefinitionColumn>,
    public val partitionKeys: List<TableSchemaDefinitionPartitionKey>,
    public val staticColumns: List<TableSchemaDefinitionStaticColumn>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.keyspaces.outputs.TableSchemaDefinition):
            TableSchemaDefinition = TableSchemaDefinition(
            clusteringKeys = javaType.clusteringKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinitionClusteringKey.Companion.toKotlin(args0)
                })
            }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinitionColumn.Companion.toKotlin(args0)
                })
            }),
            partitionKeys = javaType.partitionKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinitionPartitionKey.Companion.toKotlin(args0)
                })
            }),
            staticColumns = javaType.staticColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.keyspaces.kotlin.outputs.TableSchemaDefinitionStaticColumn.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
