@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationCloudwatchLoggingOptions
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputs
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutput
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationReferenceDataSources
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationCloudwatchLoggingOptions.Companion.toKotlin as analyticsApplicationCloudwatchLoggingOptionsToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationInputs.Companion.toKotlin as analyticsApplicationInputsToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationOutput.Companion.toKotlin as analyticsApplicationOutputToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.AnalyticsApplicationReferenceDataSources.Companion.toKotlin as analyticsApplicationReferenceDataSourcesToKotlin

/**
 * Builder for [AnalyticsApplication].
 */
@PulumiTagMarker
public class AnalyticsApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalyticsApplicationArgs = AnalyticsApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalyticsApplicationArgsBuilder.() -> Unit) {
        val builder = AnalyticsApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AnalyticsApplication {
        val builtJavaResource = com.pulumi.aws.kinesis.AnalyticsApplication(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AnalyticsApplication(builtJavaResource)
    }
}

/**
 * Provides a Kinesis Analytics Application resource. Kinesis Analytics is a managed service that
 * allows processing and analyzing streaming data using standard SQL.
 * For more details, see the [Amazon Kinesis Analytics Documentation](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/what-is.html).
 * > **Note:** To manage Amazon Kinesis Data Analytics for Apache Flink applications, use the `aws.kinesisanalyticsv2.Application` resource.
 * ## Example Usage
 * ### Kinesis Stream Input
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.AnalyticsApplication;
 * import com.pulumi.aws.kinesis.AnalyticsApplicationArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var testApplication = new AnalyticsApplication("testApplication", AnalyticsApplicationArgs.builder()
 *             .inputs(AnalyticsApplicationInputsArgs.builder()
 *                 .namePrefix("test_prefix")
 *                 .kinesisStream(AnalyticsApplicationInputsKinesisStreamArgs.builder()
 *                     .resourceArn(testStream.arn())
 *                     .roleArn(aws_iam_role.test().arn())
 *                     .build())
 *                 .parallelism(AnalyticsApplicationInputsParallelismArgs.builder()
 *                     .count(1)
 *                     .build())
 *                 .schema(AnalyticsApplicationInputsSchemaArgs.builder()
 *                     .recordColumns(AnalyticsApplicationInputsSchemaRecordColumnArgs.builder()
 *                         .mapping("$.test")
 *                         .name("test")
 *                         .sqlType("VARCHAR(8)")
 *                         .build())
 *                     .recordEncoding("UTF-8")
 *                     .recordFormat(AnalyticsApplicationInputsSchemaRecordFormatArgs.builder()
 *                         .mappingParameters(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder()
 *                             .json(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs.builder()
 *                                 .recordRowPath("$")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Starting An Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.AnalyticsApplication;
 * import com.pulumi.aws.kinesis.AnalyticsApplicationArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleLogStream = new LogStream("exampleLogStream", LogStreamArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var exampleFirehoseDeliveryStream = new FirehoseDeliveryStream("exampleFirehoseDeliveryStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .bucketArn(aws_s3_bucket.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *         var test = new AnalyticsApplication("test", AnalyticsApplicationArgs.builder()
 *             .cloudwatchLoggingOptions(AnalyticsApplicationCloudwatchLoggingOptionsArgs.builder()
 *                 .logStreamArn(exampleLogStream.arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .inputs(AnalyticsApplicationInputsArgs.builder()
 *                 .namePrefix("example_prefix")
 *                 .schema(AnalyticsApplicationInputsSchemaArgs.builder()
 *                     .recordColumns(AnalyticsApplicationInputsSchemaRecordColumnArgs.builder()
 *                         .name("COLUMN_1")
 *                         .sqlType("INTEGER")
 *                         .build())
 *                     .recordFormat(AnalyticsApplicationInputsSchemaRecordFormatArgs.builder()
 *                         .mappingParameters(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder()
 *                             .csv(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs.builder()
 *                                 .recordColumnDelimiter(",")
 *                                 .recordRowDelimiter("|")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .kinesisStream(AnalyticsApplicationInputsKinesisStreamArgs.builder()
 *                     .resourceArn(exampleStream.arn())
 *                     .roleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .startingPositionConfigurations(AnalyticsApplicationInputsStartingPositionConfigurationArgs.builder()
 *                     .startingPosition("NOW")
 *                     .build())
 *                 .build())
 *             .outputs(AnalyticsApplicationOutputArgs.builder()
 *                 .name("OUTPUT_1")
 *                 .schema(AnalyticsApplicationOutputSchemaArgs.builder()
 *                     .recordFormatType("CSV")
 *                     .build())
 *                 .kinesisFirehose(AnalyticsApplicationOutputKinesisFirehoseArgs.builder()
 *                     .resourceArn(exampleFirehoseDeliveryStream.arn())
 *                     .roleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .build())
 *             .startApplication(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Analytics Application using ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/analyticsApplication:AnalyticsApplication example arn:aws:kinesisanalytics:us-west-2:1234567890:application/example
 * ```
 *
 */
public class AnalyticsApplication internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.AnalyticsApplication,
) : KotlinCustomResource(javaResource, AnalyticsApplicationMapper) {
    /**
     * The ARN of the Kinesis Analytics Appliation.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The CloudWatch log stream options to monitor application errors.
     * See CloudWatch Logging Options below for more details.
     */
    public val cloudwatchLoggingOptions: Output<AnalyticsApplicationCloudwatchLoggingOptions>?
        get() = javaResource.cloudwatchLoggingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analyticsApplicationCloudwatchLoggingOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SQL Code to transform input data, and generate output.
     */
    public val code: Output<String>?
        get() = javaResource.code().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Timestamp when the application version was created.
     */
    public val createTimestamp: Output<String>
        get() = javaResource.createTimestamp().applyValue({ args0 -> args0 })

    /**
     * Description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Input configuration of the application. See Inputs below for more details.
     */
    public val inputs: Output<AnalyticsApplicationInputs>?
        get() = javaResource.inputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analyticsApplicationInputsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Timestamp when the application was last updated.
     */
    public val lastUpdateTimestamp: Output<String>
        get() = javaResource.lastUpdateTimestamp().applyValue({ args0 -> args0 })

    /**
     * Name of the Kinesis Analytics Application.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Output destination configuration of the application. See Outputs below for more details.
     */
    public val outputs: Output<List<AnalyticsApplicationOutput>>?
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> analyticsApplicationOutputToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * An S3 Reference Data Source for the application.
     * See Reference Data Sources below for more details.
     */
    public val referenceDataSources: Output<AnalyticsApplicationReferenceDataSources>?
        get() = javaResource.referenceDataSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analyticsApplicationReferenceDataSourcesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
     * To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
     */
    public val startApplication: Output<Boolean>?
        get() = javaResource.startApplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Status of the application.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Version of the application.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object AnalyticsApplicationMapper : ResourceMapper<AnalyticsApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.AnalyticsApplication::class == javaResource::class

    override fun map(javaResource: Resource): AnalyticsApplication = AnalyticsApplication(
        javaResource
            as com.pulumi.aws.kinesis.AnalyticsApplication,
    )
}

/**
 * @see [AnalyticsApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AnalyticsApplication].
 */
public suspend fun analyticsApplication(
    name: String,
    block: suspend AnalyticsApplicationResourceBuilder.() -> Unit,
): AnalyticsApplication {
    val builder = AnalyticsApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AnalyticsApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analyticsApplication(name: String): AnalyticsApplication {
    val builder = AnalyticsApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
