@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.AnalyticsApplicationArgs.builder
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationInputsArgs
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationInputsArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationOutputArgs
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationOutputArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationReferenceDataSourcesArgs
import com.pulumi.aws.kinesis.kotlin.inputs.AnalyticsApplicationReferenceDataSourcesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Kinesis Analytics Application resource. Kinesis Analytics is a managed service that
 * allows processing and analyzing streaming data using standard SQL.
 * For more details, see the [Amazon Kinesis Analytics Documentation](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/what-is.html).
 * > **Note:** To manage Amazon Kinesis Data Analytics for Apache Flink applications, use the `aws.kinesisanalyticsv2.Application` resource.
 * ## Example Usage
 * ### Kinesis Stream Input
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.AnalyticsApplication;
 * import com.pulumi.aws.kinesis.AnalyticsApplicationArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var testApplication = new AnalyticsApplication("testApplication", AnalyticsApplicationArgs.builder()
 *             .inputs(AnalyticsApplicationInputsArgs.builder()
 *                 .namePrefix("test_prefix")
 *                 .kinesisStream(AnalyticsApplicationInputsKinesisStreamArgs.builder()
 *                     .resourceArn(testStream.arn())
 *                     .roleArn(aws_iam_role.test().arn())
 *                     .build())
 *                 .parallelism(AnalyticsApplicationInputsParallelismArgs.builder()
 *                     .count(1)
 *                     .build())
 *                 .schema(AnalyticsApplicationInputsSchemaArgs.builder()
 *                     .recordColumns(AnalyticsApplicationInputsSchemaRecordColumnArgs.builder()
 *                         .mapping("$.test")
 *                         .name("test")
 *                         .sqlType("VARCHAR(8)")
 *                         .build())
 *                     .recordEncoding("UTF-8")
 *                     .recordFormat(AnalyticsApplicationInputsSchemaRecordFormatArgs.builder()
 *                         .mappingParameters(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder()
 *                             .json(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs.builder()
 *                                 .recordRowPath("$")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Starting An Application
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogStream;
 * import com.pulumi.aws.cloudwatch.LogStreamArgs;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.AnalyticsApplication;
 * import com.pulumi.aws.kinesis.AnalyticsApplicationArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsKinesisStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputSchemaArgs;
 * import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationOutputKinesisFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         var exampleLogStream = new LogStream("exampleLogStream", LogStreamArgs.builder()
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var exampleFirehoseDeliveryStream = new FirehoseDeliveryStream("exampleFirehoseDeliveryStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .bucketArn(aws_s3_bucket.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *         var test = new AnalyticsApplication("test", AnalyticsApplicationArgs.builder()
 *             .cloudwatchLoggingOptions(AnalyticsApplicationCloudwatchLoggingOptionsArgs.builder()
 *                 .logStreamArn(exampleLogStream.arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .inputs(AnalyticsApplicationInputsArgs.builder()
 *                 .namePrefix("example_prefix")
 *                 .schema(AnalyticsApplicationInputsSchemaArgs.builder()
 *                     .recordColumns(AnalyticsApplicationInputsSchemaRecordColumnArgs.builder()
 *                         .name("COLUMN_1")
 *                         .sqlType("INTEGER")
 *                         .build())
 *                     .recordFormat(AnalyticsApplicationInputsSchemaRecordFormatArgs.builder()
 *                         .mappingParameters(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder()
 *                             .csv(AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs.builder()
 *                                 .recordColumnDelimiter(",")
 *                                 .recordRowDelimiter("|")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .kinesisStream(AnalyticsApplicationInputsKinesisStreamArgs.builder()
 *                     .resourceArn(exampleStream.arn())
 *                     .roleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .startingPositionConfigurations(AnalyticsApplicationInputsStartingPositionConfigurationArgs.builder()
 *                     .startingPosition("NOW")
 *                     .build())
 *                 .build())
 *             .outputs(AnalyticsApplicationOutputArgs.builder()
 *                 .name("OUTPUT_1")
 *                 .schema(AnalyticsApplicationOutputSchemaArgs.builder()
 *                     .recordFormatType("CSV")
 *                     .build())
 *                 .kinesisFirehose(AnalyticsApplicationOutputKinesisFirehoseArgs.builder()
 *                     .resourceArn(exampleFirehoseDeliveryStream.arn())
 *                     .roleArn(aws_iam_role.example().arn())
 *                     .build())
 *                 .build())
 *             .startApplication(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Analytics Application using ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/analyticsApplication:AnalyticsApplication example arn:aws:kinesisanalytics:us-west-2:1234567890:application/example
 * ```
 * @property cloudwatchLoggingOptions The CloudWatch log stream options to monitor application errors.
 * See CloudWatch Logging Options below for more details.
 * @property code SQL Code to transform input data, and generate output.
 * @property description Description of the application.
 * @property inputs Input configuration of the application. See Inputs below for more details.
 * @property name Name of the Kinesis Analytics Application.
 * @property outputs Output destination configuration of the application. See Outputs below for more details.
 * @property referenceDataSources An S3 Reference Data Source for the application.
 * See Reference Data Sources below for more details.
 * @property startApplication Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
 * To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
 * @property tags Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AnalyticsApplicationArgs(
    public val cloudwatchLoggingOptions: Output<AnalyticsApplicationCloudwatchLoggingOptionsArgs>? =
        null,
    public val code: Output<String>? = null,
    public val description: Output<String>? = null,
    public val inputs: Output<AnalyticsApplicationInputsArgs>? = null,
    public val name: Output<String>? = null,
    public val outputs: Output<List<AnalyticsApplicationOutputArgs>>? = null,
    public val referenceDataSources: Output<AnalyticsApplicationReferenceDataSourcesArgs>? = null,
    public val startApplication: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.AnalyticsApplicationArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.AnalyticsApplicationArgs =
        com.pulumi.aws.kinesis.AnalyticsApplicationArgs.builder()
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .code(code?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .inputs(inputs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .referenceDataSources(
                referenceDataSources?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .startApplication(startApplication?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AnalyticsApplicationArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationArgsBuilder internal constructor() {
    private var cloudwatchLoggingOptions: Output<AnalyticsApplicationCloudwatchLoggingOptionsArgs>? =
        null

    private var code: Output<String>? = null

    private var description: Output<String>? = null

    private var inputs: Output<AnalyticsApplicationInputsArgs>? = null

    private var name: Output<String>? = null

    private var outputs: Output<List<AnalyticsApplicationOutputArgs>>? = null

    private var referenceDataSources: Output<AnalyticsApplicationReferenceDataSourcesArgs>? = null

    private var startApplication: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The CloudWatch log stream options to monitor application errors.
     * See CloudWatch Logging Options below for more details.
     */
    @JvmName("bacqmotmymqmckcg")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<AnalyticsApplicationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value SQL Code to transform input data, and generate output.
     */
    @JvmName("svknfnyoqegwellk")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("hfbkxjnpfciisrpx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Input configuration of the application. See Inputs below for more details.
     */
    @JvmName("grykqvcedcxcpufg")
    public suspend fun inputs(`value`: Output<AnalyticsApplicationInputsArgs>) {
        this.inputs = value
    }

    /**
     * @param value Name of the Kinesis Analytics Application.
     */
    @JvmName("cyxkqapcgdxcjoeh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("mwyhvgeefwklmbaf")
    public suspend fun outputs(`value`: Output<List<AnalyticsApplicationOutputArgs>>) {
        this.outputs = value
    }

    @JvmName("jdaptobgfpjpqhns")
    public suspend fun outputs(vararg values: Output<AnalyticsApplicationOutputArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("ismhuhqoveooldbw")
    public suspend fun outputs(values: List<Output<AnalyticsApplicationOutputArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value An S3 Reference Data Source for the application.
     * See Reference Data Sources below for more details.
     */
    @JvmName("ohhhmxaotovowwov")
    public suspend
    fun referenceDataSources(`value`: Output<AnalyticsApplicationReferenceDataSourcesArgs>) {
        this.referenceDataSources = value
    }

    /**
     * @param value Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
     * To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
     */
    @JvmName("nttffocyhyivcchw")
    public suspend fun startApplication(`value`: Output<Boolean>) {
        this.startApplication = value
    }

    /**
     * @param value Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gujavofhnscowlhv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The CloudWatch log stream options to monitor application errors.
     * See CloudWatch Logging Options below for more details.
     */
    @JvmName("dwjjunhetyrnmges")
    public suspend
    fun cloudwatchLoggingOptions(`value`: AnalyticsApplicationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch log stream options to monitor application errors.
     * See CloudWatch Logging Options below for more details.
     */
    @JvmName("jgkndnvhxtncvjrj")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend AnalyticsApplicationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value SQL Code to transform input data, and generate output.
     */
    @JvmName("rgajgegaqdusfidc")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("bqakrhyocomfrysa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Input configuration of the application. See Inputs below for more details.
     */
    @JvmName("dhfyjkjafxgabsxh")
    public suspend fun inputs(`value`: AnalyticsApplicationInputsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param argument Input configuration of the application. See Inputs below for more details.
     */
    @JvmName("wksctwiaxmyepohp")
    public suspend fun inputs(argument: suspend AnalyticsApplicationInputsArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputs = mapped
    }

    /**
     * @param value Name of the Kinesis Analytics Application.
     */
    @JvmName("khdxieejctmsouei")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("gouaaivyyprowryf")
    public suspend fun outputs(`value`: List<AnalyticsApplicationOutputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("sjwjfyyqyqkjcukm")
    public suspend
    fun outputs(argument: List<suspend AnalyticsApplicationOutputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("veggmsyhltrneawp")
    public suspend fun outputs(
        vararg
        argument: suspend AnalyticsApplicationOutputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationOutputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("iihbvcuqtyeucbdt")
    public suspend fun outputs(argument: suspend AnalyticsApplicationOutputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalyticsApplicationOutputArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values Output destination configuration of the application. See Outputs below for more details.
     */
    @JvmName("fommnwmpxrspvwkg")
    public suspend fun outputs(vararg values: AnalyticsApplicationOutputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value An S3 Reference Data Source for the application.
     * See Reference Data Sources below for more details.
     */
    @JvmName("qikxdfiqoohorhvx")
    public suspend fun referenceDataSources(`value`: AnalyticsApplicationReferenceDataSourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceDataSources = mapped
    }

    /**
     * @param argument An S3 Reference Data Source for the application.
     * See Reference Data Sources below for more details.
     */
    @JvmName("pyyiukcmynefhgmj")
    public suspend
    fun referenceDataSources(argument: suspend AnalyticsApplicationReferenceDataSourcesArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationReferenceDataSourcesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.referenceDataSources = mapped
    }

    /**
     * @param value Whether to start or stop the Kinesis Analytics Application. To start an application, an input with a defined `starting_position` must be configured.
     * To modify an application's starting position, first stop the application by setting `start_application = false`, then update `starting_position` and set `start_application = true`.
     */
    @JvmName("cslgsmrmfuvkqptl")
    public suspend fun startApplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startApplication = mapped
    }

    /**
     * @param value Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nyrhocueoklgtcje")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Kinesis Analytics Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qtsfbxyrlishwpqn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AnalyticsApplicationArgs = AnalyticsApplicationArgs(
        cloudwatchLoggingOptions = cloudwatchLoggingOptions,
        code = code,
        description = description,
        inputs = inputs,
        name = name,
        outputs = outputs,
        referenceDataSources = referenceDataSources,
        startApplication = startApplication,
        tags = tags,
    )
}
