@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamElasticsearchConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3Configuration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamKinesisSourceConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamMskSourceConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfiguration
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamServerSideEncryption
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamElasticsearchConfiguration.Companion.toKotlin as firehoseDeliveryStreamElasticsearchConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamExtendedS3Configuration.Companion.toKotlin as firehoseDeliveryStreamExtendedS3ConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfiguration.Companion.toKotlin as firehoseDeliveryStreamHttpEndpointConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamKinesisSourceConfiguration.Companion.toKotlin as firehoseDeliveryStreamKinesisSourceConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamMskSourceConfiguration.Companion.toKotlin as firehoseDeliveryStreamMskSourceConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchConfiguration.Companion.toKotlin as firehoseDeliveryStreamOpensearchConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamOpensearchserverlessConfiguration.Companion.toKotlin as firehoseDeliveryStreamOpensearchserverlessConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfiguration.Companion.toKotlin as firehoseDeliveryStreamRedshiftConfigurationToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamServerSideEncryption.Companion.toKotlin as firehoseDeliveryStreamServerSideEncryptionToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfiguration.Companion.toKotlin as firehoseDeliveryStreamSplunkConfigurationToKotlin

/**
 * Builder for [FirehoseDeliveryStream].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirehoseDeliveryStreamArgs = FirehoseDeliveryStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirehoseDeliveryStreamArgsBuilder.() -> Unit) {
        val builder = FirehoseDeliveryStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FirehoseDeliveryStream {
        val builtJavaResource = com.pulumi.aws.kinesis.FirehoseDeliveryStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FirehoseDeliveryStream(builtJavaResource)
    }
}

/**
 * Provides a Kinesis Firehose Delivery Stream resource. Amazon Kinesis Firehose is a fully managed, elastic service to easily deliver real-time data streams to destinations such as Amazon S3 and Amazon Redshift.
 * For more details, see the [Amazon Kinesis Firehose Documentation](https://aws.amazon.com/documentation/firehose/).
 * ## Example Usage
 * ### Extended S3 Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         final var firehoseAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseRole = new Role("firehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(firehoseAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var lambdaIam = new Role("lambdaIam", RoleArgs.builder()
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambdaProcessor = new Function("lambdaProcessor", FunctionArgs.builder()
 *             .code(new FileArchive("lambda.zip"))
 *             .role(lambdaIam.arn())
 *             .handler("exports.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(lambdaProcessor.arn().applyValue(arn -> String.format("%s:$LATEST", arn)))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ### Extended S3 Destination with dynamic partitioning
 * These examples use built-in Firehose functionality, rather than requiring a lambda.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .bucketArn(aws_s3_bucket.bucket().arn())
 *                 .bufferingSize(64)
 *                 .dynamicPartitioningConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .build())
 *                 .prefix("data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/")
 *                 .errorOutputPrefix("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/")
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("RecordDeAggregation")
 *                             .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                 .parameterName("SubRecordType")
 *                                 .parameterValue("JSON")
 *                                 .build())
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("AppendDelimiterToRecord")
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("MetadataExtraction")
 *                             .parameters(
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("JsonParsingEngine")
 *                                     .parameterValue("JQ-1.6")
 *                                     .build(),
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("MetadataExtractionQuery")
 *                                     .parameterValue("{customer_id:.customer_id}")
 *                                     .build())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Redshift Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("test")
 *             .masterUsername("testuser")
 *             .masterPassword("T3stPass")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("redshift")
 *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .clusterJdbcurl(Output.tuple(testCluster.endpoint(), testCluster.databaseName()).applyValue(values -> {
 *                     var endpoint = values.t1;
 *                     var databaseName = values.t2;
 *                     return String.format("jdbc:redshift://%s/%s", endpoint,databaseName);
 *                 }))
 *                 .username("testuser")
 *                 .password("T3stPass")
 *                 .dataTableName("test-table")
 *                 .copyOptions("delimiter '|'")
 *                 .dataTableColumns("test-col")
 *                 .s3BackupMode("Enabled")
 *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .s3BackupConfiguration(FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(15)
 *                     .bufferingInterval(300)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Elasticsearch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Elasticsearch Destination With VPC
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("t2.small.elasticsearch")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(aws_security_group.first().id())
 *                 .subnetIds(
 *                     aws_subnet.first().id(),
 *                     aws_subnet.second().id())
 *                 .build())
 *             .build());
 *         final var firehose-elasticsearchPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("es:*")
 *                     .resources(
 *                         testCluster.arn(),
 *                         testCluster.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:DescribeVpcs",
 *                         "ec2:DescribeVpcAttribute",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:CreateNetworkInterfacePermission",
 *                         "ec2:DeleteNetworkInterface")
 *                     .resources("*")
 *                     .build())
 *             .build());
 *         var firehose_elasticsearchRolePolicy = new RolePolicy("firehose-elasticsearchRolePolicy", RolePolicyArgs.builder()
 *             .role(aws_iam_role.firehose().id())
 *             .policy(firehose_elasticsearchPolicyDocument.applyValue(firehose_elasticsearchPolicyDocument -> firehose_elasticsearchPolicyDocument.json()))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         aws_subnet.first().id(),
 *                         aws_subnet.second().id())
 *                     .securityGroupIds(aws_security_group.first().id())
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_elasticsearchRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### OpenSearch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### OpenSearch Destination With VPC
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("m4.large.search")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(aws_security_group.first().id())
 *                 .subnetIds(
 *                     aws_subnet.first().id(),
 *                     aws_subnet.second().id())
 *                 .build())
 *             .build());
 *         var firehose_opensearch = new RolePolicy("firehose-opensearch", RolePolicyArgs.builder()
 *             .role(aws_iam_role.firehose().id())
 *             .policy(Output.tuple(testCluster.arn(), testCluster.arn()).applyValue(values -> {
 *                 var testClusterArn = values.t1;
 *                 var testClusterArn1 = values.t2;
 *                 return """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "%s",
 *         "%s/*"
 *       ]
 *         },
 *         {
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }
 *   ]
 * }
 * ", testClusterArn,testClusterArn1);
 *             }))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         aws_subnet.first().id(),
 *                         aws_subnet.second().id())
 *                     .securityGroupIds(aws_security_group.first().id())
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_opensearch)
 *                 .build());
 *     }
 * }
 * ```
 * ### OpenSearch Serverless Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessCollection;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCollection = new ServerlessCollection("testCollection");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearchserverless")
 *             .opensearchserverlessConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs.builder()
 *                 .collectionEndpoint(testCollection.collectionEndpoint())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Splunk Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("splunk")
 *             .splunkConfiguration(FirehoseDeliveryStreamSplunkConfigurationArgs.builder()
 *                 .hecEndpoint("https://http-inputs-mydomain.splunkcloud.com:443")
 *                 .hecToken("51D4DA16-C61B-4F5F-8EC7-ED4301342A4A")
 *                 .hecAcknowledgmentTimeout(600)
 *                 .hecEndpointType("Event")
 *                 .s3BackupMode("FailedEventsOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### HTTP Endpoint (e.g., New Relic) Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("http_endpoint")
 *             .httpEndpointConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationArgs.builder()
 *                 .url("https://aws-api.newrelic.com/firehose/v1")
 *                 .name("New Relic")
 *                 .accessKey("my-key")
 *                 .bufferingSize(15)
 *                 .bufferingInterval(600)
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .s3BackupMode("FailedDataOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .requestConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs.builder()
 *                     .contentEncoding("GZIP")
 *                     .commonAttributes(
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname")
 *                             .value("testvalue")
 *                             .build(),
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname2")
 *                             .value("testvalue2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Firehose Delivery streams using the stream ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/firehoseDeliveryStream:FirehoseDeliveryStream foo arn:aws:firehose:us-east-1:XXX:deliverystream/example
 * ```
 *  NoteImport does not work for stream destination `s3`. Consider using `extended_s3` since `s3` destination is deprecated.
 * */*/
 */
public class FirehoseDeliveryStream internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.FirehoseDeliveryStream,
) : KotlinCustomResource(javaResource, FirehoseDeliveryStreamMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the Stream
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch` and `opensearchserverless`.
     * is redshift). More details are given below.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    public val destinationId: Output<String>
        get() = javaResource.destinationId().applyValue({ args0 -> args0 })

    /**
     * Configuration options when `destination` is `elasticsearch`. More details are given below.
     */
    public val elasticsearchConfiguration: Output<FirehoseDeliveryStreamElasticsearchConfiguration>?
        get() = javaResource.elasticsearchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamElasticsearchConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Enhanced configuration options for the s3 destination. More details are given below.
     */
    public val extendedS3Configuration: Output<FirehoseDeliveryStreamExtendedS3Configuration>?
        get() = javaResource.extendedS3Configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamExtendedS3ConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  More details are given below.
     */
    public val httpEndpointConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfiguration>?
        get() = javaResource.httpEndpointConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamHttpEndpointConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. More details are given below.
     */
    public val kinesisSourceConfiguration: Output<FirehoseDeliveryStreamKinesisSourceConfiguration>?
        get() = javaResource.kinesisSourceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamKinesisSourceConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. More details are given below.
     */
    public val mskSourceConfiguration: Output<FirehoseDeliveryStreamMskSourceConfiguration>?
        get() = javaResource.mskSourceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamMskSourceConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration options when `destination` is `opensearch`. More details are given below.
     */
    public val opensearchConfiguration: Output<FirehoseDeliveryStreamOpensearchConfiguration>?
        get() = javaResource.opensearchConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamOpensearchConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration options when `destination` is `opensearchserverless`. More details are given below.
     */
    public val opensearchserverlessConfiguration:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfiguration>?
        get() = javaResource.opensearchserverlessConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamOpensearchserverlessConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. More details are given below.
     */
    public val redshiftConfiguration: Output<FirehoseDeliveryStreamRedshiftConfiguration>?
        get() = javaResource.redshiftConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamRedshiftConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Encrypt at rest options.
     * Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    public val serverSideEncryption: Output<FirehoseDeliveryStreamServerSideEncryption>?
        get() = javaResource.serverSideEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamServerSideEncryptionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configuration options when `destination` is `splunk`. More details are given below.
     */
    public val splunkConfiguration: Output<FirehoseDeliveryStreamSplunkConfiguration>?
        get() = javaResource.splunkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    firehoseDeliveryStreamSplunkConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the table version for the output data schema. Defaults to `LATEST`.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })
}

public object FirehoseDeliveryStreamMapper : ResourceMapper<FirehoseDeliveryStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.FirehoseDeliveryStream::class == javaResource::class

    override fun map(javaResource: Resource): FirehoseDeliveryStream =
        FirehoseDeliveryStream(javaResource as com.pulumi.aws.kinesis.FirehoseDeliveryStream)
}

/**
 * @see [FirehoseDeliveryStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirehoseDeliveryStream].
 */
public suspend fun firehoseDeliveryStream(
    name: String,
    block: suspend FirehoseDeliveryStreamResourceBuilder.() -> Unit,
): FirehoseDeliveryStream {
    val builder = FirehoseDeliveryStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirehoseDeliveryStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firehoseDeliveryStream(name: String): FirehoseDeliveryStream {
    val builder = FirehoseDeliveryStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
