@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs.builder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamServerSideEncryptionArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamServerSideEncryptionArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs
import com.pulumi.aws.kinesis.kotlin.inputs.FirehoseDeliveryStreamSplunkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Kinesis Firehose Delivery Stream resource. Amazon Kinesis Firehose is a fully managed, elastic service to easily deliver real-time data streams to destinations such as Amazon S3 and Amazon Redshift.
 * For more details, see the [Amazon Kinesis Firehose Documentation](https://aws.amazon.com/documentation/firehose/).
 * ## Example Usage
 * ### Extended S3 Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bucket = new BucketV2("bucket");
 *         final var firehoseAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var firehoseRole = new Role("firehoseRole", RoleArgs.builder()
 *             .assumeRolePolicy(firehoseAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var lambdaIam = new Role("lambdaIam", RoleArgs.builder()
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var lambdaProcessor = new Function("lambdaProcessor", FunctionArgs.builder()
 *             .code(new FileArchive("lambda.zip"))
 *             .role(lambdaIam.arn())
 *             .handler("exports.handler")
 *             .runtime("nodejs16.x")
 *             .build());
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(firehoseRole.arn())
 *                 .bucketArn(bucket.arn())
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(lambdaProcessor.arn().applyValue(arn -> String.format("%s:$LATEST", arn)))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var bucketAcl = new BucketAclV2("bucketAcl", BucketAclV2Args.builder()
 *             .bucket(bucket.id())
 *             .acl("private")
 *             .build());
 *     }
 * }
 * ```
 * ### Extended S3 Destination with dynamic partitioning
 * These examples use built-in Firehose functionality, rather than requiring a lambda.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedS3Stream = new FirehoseDeliveryStream("extendedS3Stream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .bucketArn(aws_s3_bucket.bucket().arn())
 *                 .bufferingSize(64)
 *                 .dynamicPartitioningConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .build())
 *                 .prefix("data/customer_id=!{partitionKeyFromQuery:customer_id}/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/")
 *                 .errorOutputPrefix("errors/year=!{timestamp:yyyy}/month=!{timestamp:MM}/day=!{timestamp:dd}/hour=!{timestamp:HH}/!{firehose:error-output-type}/")
 *                 .processingConfiguration(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("RecordDeAggregation")
 *                             .parameters(FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                 .parameterName("SubRecordType")
 *                                 .parameterValue("JSON")
 *                                 .build())
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("AppendDelimiterToRecord")
 *                             .build(),
 *                         FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorArgs.builder()
 *                             .type("MetadataExtraction")
 *                             .parameters(
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("JsonParsingEngine")
 *                                     .parameterValue("JQ-1.6")
 *                                     .build(),
 *                                 FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                                     .parameterName("MetadataExtractionQuery")
 *                                     .parameterValue("{customer_id:.customer_id}")
 *                                     .build())
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Redshift Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
 *             .clusterIdentifier("tf-redshift-cluster")
 *             .databaseName("test")
 *             .masterUsername("testuser")
 *             .masterPassword("T3stPass")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("redshift")
 *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .clusterJdbcurl(Output.tuple(testCluster.endpoint(), testCluster.databaseName()).applyValue(values -> {
 *                     var endpoint = values.t1;
 *                     var databaseName = values.t2;
 *                     return String.format("jdbc:redshift://%s/%s", endpoint,databaseName);
 *                 }))
 *                 .username("testuser")
 *                 .password("T3stPass")
 *                 .dataTableName("test-table")
 *                 .copyOptions("delimiter '|'")
 *                 .dataTableColumns("test-col")
 *                 .s3BackupMode("Enabled")
 *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .s3BackupConfiguration(FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(15)
 *                     .bufferingInterval(300)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Elasticsearch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Elasticsearch Destination With VPC
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.elasticsearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("t2.small.elasticsearch")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(aws_security_group.first().id())
 *                 .subnetIds(
 *                     aws_subnet.first().id(),
 *                     aws_subnet.second().id())
 *                 .build())
 *             .build());
 *         final var firehose-elasticsearchPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("es:*")
 *                     .resources(
 *                         testCluster.arn(),
 *                         testCluster.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:DescribeVpcs",
 *                         "ec2:DescribeVpcAttribute",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:CreateNetworkInterfacePermission",
 *                         "ec2:DeleteNetworkInterface")
 *                     .resources("*")
 *                     .build())
 *             .build());
 *         var firehose_elasticsearchRolePolicy = new RolePolicy("firehose-elasticsearchRolePolicy", RolePolicyArgs.builder()
 *             .role(aws_iam_role.firehose().id())
 *             .policy(firehose_elasticsearchPolicyDocument.applyValue(firehose_elasticsearchPolicyDocument -> firehose_elasticsearchPolicyDocument.json()))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .destination("elasticsearch")
 *             .elasticsearchConfiguration(FirehoseDeliveryStreamElasticsearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .indexName("test")
 *                 .typeName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamElasticsearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         aws_subnet.first().id(),
 *                         aws_subnet.second().id())
 *                     .securityGroupIds(aws_security_group.first().id())
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_elasticsearchRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ### OpenSearch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### OpenSearch Destination With VPC
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.Domain;
 * import com.pulumi.aws.opensearch.DomainArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainClusterConfigArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainEbsOptionsArgs;
 * import com.pulumi.aws.opensearch.inputs.DomainVpcOptionsArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCluster = new Domain("testCluster", DomainArgs.builder()
 *             .clusterConfig(DomainClusterConfigArgs.builder()
 *                 .instanceCount(2)
 *                 .zoneAwarenessEnabled(true)
 *                 .instanceType("m4.large.search")
 *                 .build())
 *             .ebsOptions(DomainEbsOptionsArgs.builder()
 *                 .ebsEnabled(true)
 *                 .volumeSize(10)
 *                 .build())
 *             .vpcOptions(DomainVpcOptionsArgs.builder()
 *                 .securityGroupIds(aws_security_group.first().id())
 *                 .subnetIds(
 *                     aws_subnet.first().id(),
 *                     aws_subnet.second().id())
 *                 .build())
 *             .build());
 *         var firehose_opensearch = new RolePolicy("firehose-opensearch", RolePolicyArgs.builder()
 *             .role(aws_iam_role.firehose().id())
 *             .policy(Output.tuple(testCluster.arn(), testCluster.arn()).applyValue(values -> {
 *                 var testClusterArn = values.t1;
 *                 var testClusterArn1 = values.t2;
 *                 return """
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Effect": "Allow",
 *       "Action": [
 *         "es:*"
 *       ],
 *       "Resource": [
 *         "%s",
 *         "%s/*"
 *       ]
 *         },
 *         {
 *           "Effect": "Allow",
 *           "Action": [
 *             "ec2:DescribeVpcs",
 *             "ec2:DescribeVpcAttribute",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:CreateNetworkInterface",
 *             "ec2:CreateNetworkInterfacePermission",
 *             "ec2:DeleteNetworkInterface"
 *           ],
 *           "Resource": [
 *             "*"
 *           ]
 *         }
 *   ]
 * }
 * ", testClusterArn,testClusterArn1);
 *             }))
 *             .build());
 *         var test = new FirehoseDeliveryStream("test", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearch")
 *             .opensearchConfiguration(FirehoseDeliveryStreamOpensearchConfigurationArgs.builder()
 *                 .domainArn(testCluster.arn())
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .build())
 *                 .vpcConfig(FirehoseDeliveryStreamOpensearchConfigurationVpcConfigArgs.builder()
 *                     .subnetIds(
 *                         aws_subnet.first().id(),
 *                         aws_subnet.second().id())
 *                     .securityGroupIds(aws_security_group.first().id())
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(firehose_opensearch)
 *                 .build());
 *     }
 * }
 * ```
 * ### OpenSearch Serverless Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.opensearch.ServerlessCollection;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testCollection = new ServerlessCollection("testCollection");
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("opensearchserverless")
 *             .opensearchserverlessConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs.builder()
 *                 .collectionEndpoint(testCollection.collectionEndpoint())
 *                 .roleArn(aws_iam_role.firehose_role().arn())
 *                 .indexName("test")
 *                 .s3Configuration(FirehoseDeliveryStreamOpensearchserverlessConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose_role().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .processingConfiguration(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationArgs.builder()
 *                     .enabled("true")
 *                     .processors(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorArgs.builder()
 *                         .type("Lambda")
 *                         .parameters(FirehoseDeliveryStreamOpensearchserverlessConfigurationProcessingConfigurationProcessorParameterArgs.builder()
 *                             .parameterName("LambdaArn")
 *                             .parameterValue(String.format("%s:$LATEST", aws_lambda_function.lambda_processor().arn()))
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Splunk Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("splunk")
 *             .splunkConfiguration(FirehoseDeliveryStreamSplunkConfigurationArgs.builder()
 *                 .hecEndpoint("https://http-inputs-mydomain.splunkcloud.com:443")
 *                 .hecToken("51D4DA16-C61B-4F5F-8EC7-ED4301342A4A")
 *                 .hecAcknowledgmentTimeout(600)
 *                 .hecEndpointType("Event")
 *                 .s3BackupMode("FailedEventsOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamSplunkConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### HTTP Endpoint (e.g., New Relic) Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new FirehoseDeliveryStream("testStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("http_endpoint")
 *             .httpEndpointConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationArgs.builder()
 *                 .url("https://aws-api.newrelic.com/firehose/v1")
 *                 .name("New Relic")
 *                 .accessKey("my-key")
 *                 .bufferingSize(15)
 *                 .bufferingInterval(600)
 *                 .roleArn(aws_iam_role.firehose().arn())
 *                 .s3BackupMode("FailedDataOnly")
 *                 .s3Configuration(FirehoseDeliveryStreamHttpEndpointConfigurationS3ConfigurationArgs.builder()
 *                     .roleArn(aws_iam_role.firehose().arn())
 *                     .bucketArn(aws_s3_bucket.bucket().arn())
 *                     .bufferingSize(10)
 *                     .bufferingInterval(400)
 *                     .compressionFormat("GZIP")
 *                     .build())
 *                 .requestConfiguration(FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationArgs.builder()
 *                     .contentEncoding("GZIP")
 *                     .commonAttributes(
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname")
 *                             .value("testvalue")
 *                             .build(),
 *                         FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttributeArgs.builder()
 *                             .name("testname2")
 *                             .value("testvalue2")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Firehose Delivery streams using the stream ARN. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/firehoseDeliveryStream:FirehoseDeliveryStream foo arn:aws:firehose:us-east-1:XXX:deliverystream/example
 * ```
 *  NoteImport does not work for stream destination `s3`. Consider using `extended_s3` since `s3` destination is deprecated.
 * @property arn The Amazon Resource Name (ARN) specifying the Stream
 * @property destination This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch` and `opensearchserverless`.
 * is redshift). More details are given below.
 * @property destinationId
 * @property elasticsearchConfiguration Configuration options when `destination` is `elasticsearch`. More details are given below.
 * @property extendedS3Configuration Enhanced configuration options for the s3 destination. More details are given below.
 * @property httpEndpointConfiguration Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  More details are given below.
 * @property kinesisSourceConfiguration The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. More details are given below.
 * @property mskSourceConfiguration The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. More details are given below.
 * @property name A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
 * @property opensearchConfiguration Configuration options when `destination` is `opensearch`. More details are given below.
 * @property opensearchserverlessConfiguration Configuration options when `destination` is `opensearchserverless`. More details are given below.
 * @property redshiftConfiguration Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. More details are given below.
 * @property serverSideEncryption Encrypt at rest options.
 * Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
 * @property splunkConfiguration Configuration options when `destination` is `splunk`. More details are given below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property versionId Specifies the table version for the output data schema. Defaults to `LATEST`.
 * */*/
 */
public data class FirehoseDeliveryStreamArgs(
    public val arn: Output<String>? = null,
    public val destination: Output<String>? = null,
    public val destinationId: Output<String>? = null,
    public val elasticsearchConfiguration:
    Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>? = null,
    public val extendedS3Configuration: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>? =
        null,
    public val httpEndpointConfiguration: Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>? =
        null,
    public val kinesisSourceConfiguration:
    Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>? = null,
    public val mskSourceConfiguration: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>? =
        null,
    public val name: Output<String>? = null,
    public val opensearchConfiguration: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>? =
        null,
    public val opensearchserverlessConfiguration:
    Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>? = null,
    public val redshiftConfiguration: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>? = null,
    public val serverSideEncryption: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>? = null,
    public val splunkConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs =
        com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0 }))
            .destinationId(destinationId?.applyValue({ args0 -> args0 }))
            .elasticsearchConfiguration(
                elasticsearchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .extendedS3Configuration(
                extendedS3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpEndpointConfiguration(
                httpEndpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kinesisSourceConfiguration(
                kinesisSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mskSourceConfiguration(
                mskSourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .opensearchConfiguration(
                opensearchConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .opensearchserverlessConfiguration(
                opensearchserverlessConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .redshiftConfiguration(
                redshiftConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serverSideEncryption(
                serverSideEncryption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .splunkConfiguration(
                splunkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var destination: Output<String>? = null

    private var destinationId: Output<String>? = null

    private var elasticsearchConfiguration:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>? = null

    private var extendedS3Configuration: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>? =
        null

    private var httpEndpointConfiguration:
        Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>? = null

    private var kinesisSourceConfiguration:
        Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>? = null

    private var mskSourceConfiguration: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>? =
        null

    private var name: Output<String>? = null

    private var opensearchConfiguration: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>? =
        null

    private var opensearchserverlessConfiguration:
        Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>? = null

    private var redshiftConfiguration: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>? = null

    private var serverSideEncryption: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>? = null

    private var splunkConfiguration: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream
     */
    @JvmName("uiqkabhdhfthyykp")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch` and `opensearchserverless`.
     * is redshift). More details are given below.
     */
    @JvmName("tfnfujnfqyotnhfn")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value
     */
    @JvmName("mrwuceirlkvpacsx")
    public suspend fun destinationId(`value`: Output<String>) {
        this.destinationId = value
    }

    /**
     * @param value Configuration options when `destination` is `elasticsearch`. More details are given below.
     */
    @JvmName("cblfegbywklmqtha")
    public suspend
    fun elasticsearchConfiguration(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationArgs>) {
        this.elasticsearchConfiguration = value
    }

    /**
     * @param value Enhanced configuration options for the s3 destination. More details are given below.
     */
    @JvmName("rwqlopfsauhlixlo")
    public suspend
    fun extendedS3Configuration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationArgs>) {
        this.extendedS3Configuration = value
    }

    /**
     * @param value Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  More details are given below.
     */
    @JvmName("ldxnevyuglmpxpmh")
    public suspend
    fun httpEndpointConfiguration(`value`: Output<FirehoseDeliveryStreamHttpEndpointConfigurationArgs>) {
        this.httpEndpointConfiguration = value
    }

    /**
     * @param value The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. More details are given below.
     */
    @JvmName("fuyjvmmegwpkqdcm")
    public suspend
    fun kinesisSourceConfiguration(`value`: Output<FirehoseDeliveryStreamKinesisSourceConfigurationArgs>) {
        this.kinesisSourceConfiguration = value
    }

    /**
     * @param value The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. More details are given below.
     */
    @JvmName("bnkxqiknaeapvicx")
    public suspend
    fun mskSourceConfiguration(`value`: Output<FirehoseDeliveryStreamMskSourceConfigurationArgs>) {
        this.mskSourceConfiguration = value
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
     */
    @JvmName("gnbyjsrrpklhhejh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration options when `destination` is `opensearch`. More details are given below.
     */
    @JvmName("psrylequnxsbxjjc")
    public suspend
    fun opensearchConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchConfigurationArgs>) {
        this.opensearchConfiguration = value
    }

    /**
     * @param value Configuration options when `destination` is `opensearchserverless`. More details are given below.
     */
    @JvmName("caopxpjomrxwvjjy")
    public suspend
    fun opensearchserverlessConfiguration(`value`: Output<FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs>) {
        this.opensearchserverlessConfiguration = value
    }

    /**
     * @param value Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. More details are given below.
     */
    @JvmName("aoslkglfuviiiypt")
    public suspend
    fun redshiftConfiguration(`value`: Output<FirehoseDeliveryStreamRedshiftConfigurationArgs>) {
        this.redshiftConfiguration = value
    }

    /**
     * @param value Encrypt at rest options.
     * Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("ckseygygbhyjkyrt")
    public suspend
    fun serverSideEncryption(`value`: Output<FirehoseDeliveryStreamServerSideEncryptionArgs>) {
        this.serverSideEncryption = value
    }

    /**
     * @param value Configuration options when `destination` is `splunk`. More details are given below.
     */
    @JvmName("cbthoyvwaioatufv")
    public suspend
    fun splunkConfiguration(`value`: Output<FirehoseDeliveryStreamSplunkConfigurationArgs>) {
        this.splunkConfiguration = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yysgawwkwguuwtpe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the table version for the output data schema. Defaults to `LATEST`.
     */
    @JvmName("xhqseucadwwgqihs")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream
     */
    @JvmName("jypawgxmyeiqhmuc")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value This is the destination to where the data is delivered. The only options are `s3` (Deprecated, use `extended_s3` instead), `extended_s3`, `redshift`, `elasticsearch`, `splunk`, `http_endpoint`, `opensearch` and `opensearchserverless`.
     * is redshift). More details are given below.
     */
    @JvmName("psghpgoadeaquaog")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value
     */
    @JvmName("mlbtlsmoaklpqymn")
    public suspend fun destinationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationId = mapped
    }

    /**
     * @param value Configuration options when `destination` is `elasticsearch`. More details are given below.
     */
    @JvmName("pmuwutrrxhprkdtw")
    public suspend
    fun elasticsearchConfiguration(`value`: FirehoseDeliveryStreamElasticsearchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `elasticsearch`. More details are given below.
     */
    @JvmName("tsuvsnhjboiisbtt")
    public suspend
    fun elasticsearchConfiguration(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamElasticsearchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticsearchConfiguration = mapped
    }

    /**
     * @param value Enhanced configuration options for the s3 destination. More details are given below.
     */
    @JvmName("oqfanddmsrvdqqyg")
    public suspend
    fun extendedS3Configuration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedS3Configuration = mapped
    }

    /**
     * @param argument Enhanced configuration options for the s3 destination. More details are given below.
     */
    @JvmName("roxmoyltpltrxgte")
    public suspend
    fun extendedS3Configuration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedS3Configuration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  More details are given below.
     */
    @JvmName("adfnldjikfqkttmj")
    public suspend
    fun httpEndpointConfiguration(`value`: FirehoseDeliveryStreamHttpEndpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpointConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `http_endpoint`. Requires the user to also specify an `s3_configuration` block.  More details are given below.
     */
    @JvmName("jwkcdmlahptcdlrp")
    public suspend
    fun httpEndpointConfiguration(argument: suspend FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamHttpEndpointConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpEndpointConfiguration = mapped
    }

    /**
     * @param value The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. More details are given below.
     */
    @JvmName("uigvjsvjushleouh")
    public suspend
    fun kinesisSourceConfiguration(`value`: FirehoseDeliveryStreamKinesisSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisSourceConfiguration = mapped
    }

    /**
     * @param argument The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream used as the source for a delivery stream. More details are given below.
     */
    @JvmName("byrnkvshyiuxuyfn")
    public suspend
    fun kinesisSourceConfiguration(argument: suspend FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamKinesisSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisSourceConfiguration = mapped
    }

    /**
     * @param value The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. More details are given below.
     */
    @JvmName("kpeaxgitiwomvitp")
    public suspend
    fun mskSourceConfiguration(`value`: FirehoseDeliveryStreamMskSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mskSourceConfiguration = mapped
    }

    /**
     * @param argument The configuration for the Amazon MSK cluster to be used as the source for a delivery stream. More details are given below.
     */
    @JvmName("ddugfliwpgwwbabm")
    public suspend
    fun mskSourceConfiguration(argument: suspend FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamMskSourceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mskSourceConfiguration = mapped
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in. When using for WAF logging, name must be prefixed with `aws-waf-logs-`. See [AWS Documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-policies.html#waf-policies-logging-config) for more details.
     */
    @JvmName("xuxlwjlwnqhdkgyv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration options when `destination` is `opensearch`. More details are given below.
     */
    @JvmName("lkbpmmlbekbynygd")
    public suspend
    fun opensearchConfiguration(`value`: FirehoseDeliveryStreamOpensearchConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `opensearch`. More details are given below.
     */
    @JvmName("cuegmaaogbadwmtf")
    public suspend
    fun opensearchConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamOpensearchConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.opensearchConfiguration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `opensearchserverless`. More details are given below.
     */
    @JvmName("knrdrbqqhyanjnln")
    public suspend
    fun opensearchserverlessConfiguration(`value`: FirehoseDeliveryStreamOpensearchserverlessConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opensearchserverlessConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `opensearchserverless`. More details are given below.
     */
    @JvmName("qmflykthijrxrrrf")
    public suspend
    fun opensearchserverlessConfiguration(argument: suspend FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamOpensearchserverlessConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.opensearchserverlessConfiguration = mapped
    }

    /**
     * @param value Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. More details are given below.
     */
    @JvmName("wywmwhiogbtgumvs")
    public suspend
    fun redshiftConfiguration(`value`: FirehoseDeliveryStreamRedshiftConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `redshift`. Requires the user to also specify an `s3_configuration` block. More details are given below.
     */
    @JvmName("vyveymlagdhwpjhd")
    public suspend
    fun redshiftConfiguration(argument: suspend FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamRedshiftConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redshiftConfiguration = mapped
    }

    /**
     * @param value Encrypt at rest options.
     * Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("gkytcfxcqunajijw")
    public suspend
    fun serverSideEncryption(`value`: FirehoseDeliveryStreamServerSideEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverSideEncryption = mapped
    }

    /**
     * @param argument Encrypt at rest options.
     * Server-side encryption should not be enabled when a kinesis stream is configured as the source of the firehose delivery stream.
     */
    @JvmName("niugqytwhgdmjnpu")
    public suspend
    fun serverSideEncryption(argument: suspend FirehoseDeliveryStreamServerSideEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamServerSideEncryptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverSideEncryption = mapped
    }

    /**
     * @param value Configuration options when `destination` is `splunk`. More details are given below.
     */
    @JvmName("hphqdkkahfxmqnaw")
    public suspend fun splunkConfiguration(`value`: FirehoseDeliveryStreamSplunkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.splunkConfiguration = mapped
    }

    /**
     * @param argument Configuration options when `destination` is `splunk`. More details are given below.
     */
    @JvmName("orijjvyaigeyrbvc")
    public suspend
    fun splunkConfiguration(argument: suspend FirehoseDeliveryStreamSplunkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirehoseDeliveryStreamSplunkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.splunkConfiguration = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dwtssrxotjahitvd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mjkuqxcnfgqmilfj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the table version for the output data schema. Defaults to `LATEST`.
     */
    @JvmName("lcddtghfpndmolvy")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): FirehoseDeliveryStreamArgs = FirehoseDeliveryStreamArgs(
        arn = arn,
        destination = destination,
        destinationId = destinationId,
        elasticsearchConfiguration = elasticsearchConfiguration,
        extendedS3Configuration = extendedS3Configuration,
        httpEndpointConfiguration = httpEndpointConfiguration,
        kinesisSourceConfiguration = kinesisSourceConfiguration,
        mskSourceConfiguration = mskSourceConfiguration,
        name = name,
        opensearchConfiguration = opensearchConfiguration,
        opensearchserverlessConfiguration = opensearchserverlessConfiguration,
        redshiftConfiguration = redshiftConfiguration,
        serverSideEncryption = serverSideEncryption,
        splunkConfiguration = splunkConfiguration,
        tags = tags,
        versionId = versionId,
    )
}
