@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.KinesisFunctions.getFirehoseDeliveryStreamPlain
import com.pulumi.aws.kinesis.KinesisFunctions.getStreamConsumerPlain
import com.pulumi.aws.kinesis.KinesisFunctions.getStreamPlain
import com.pulumi.aws.kinesis.kotlin.inputs.GetFirehoseDeliveryStreamPlainArgs
import com.pulumi.aws.kinesis.kotlin.inputs.GetFirehoseDeliveryStreamPlainArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.GetStreamConsumerPlainArgs
import com.pulumi.aws.kinesis.kotlin.inputs.GetStreamConsumerPlainArgsBuilder
import com.pulumi.aws.kinesis.kotlin.inputs.GetStreamPlainArgs
import com.pulumi.aws.kinesis.kotlin.inputs.GetStreamPlainArgsBuilder
import com.pulumi.aws.kinesis.kotlin.outputs.GetFirehoseDeliveryStreamResult
import com.pulumi.aws.kinesis.kotlin.outputs.GetStreamConsumerResult
import com.pulumi.aws.kinesis.kotlin.outputs.GetStreamResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.kinesis.kotlin.outputs.GetFirehoseDeliveryStreamResult.Companion.toKotlin as getFirehoseDeliveryStreamResultToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.GetStreamConsumerResult.Companion.toKotlin as getStreamConsumerResultToKotlin
import com.pulumi.aws.kinesis.kotlin.outputs.GetStreamResult.Companion.toKotlin as getStreamResultToKotlin

public object KinesisFunctions {
    /**
     * Use this data source to get information about a Kinesis Firehose Delivery Stream for use in other resources.
     * For more details, see the [Amazon Kinesis Firehose Documentation](https://aws.amazon.com/documentation/firehose/).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kinesis.KinesisFunctions;
     * import com.pulumi.aws.kinesis.inputs.GetFirehoseDeliveryStreamArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var stream = KinesisFunctions.getFirehoseDeliveryStream(GetFirehoseDeliveryStreamArgs.builder()
     *             .name("stream-name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getFirehoseDeliveryStream.
     * @return A collection of values returned by getFirehoseDeliveryStream.
     */
    public suspend fun getFirehoseDeliveryStream(argument: GetFirehoseDeliveryStreamPlainArgs):
        GetFirehoseDeliveryStreamResult =
        getFirehoseDeliveryStreamResultToKotlin(getFirehoseDeliveryStreamPlain(argument.toJava()).await())

    /**
     * @see [getFirehoseDeliveryStream].
     * @param name Name of the Kinesis Stream.
     * @return A collection of values returned by getFirehoseDeliveryStream.
     */
    public suspend fun getFirehoseDeliveryStream(name: String): GetFirehoseDeliveryStreamResult {
        val argument = GetFirehoseDeliveryStreamPlainArgs(
            name = name,
        )
        return getFirehoseDeliveryStreamResultToKotlin(getFirehoseDeliveryStreamPlain(argument.toJava()).await())
    }

    /**
     * @see [getFirehoseDeliveryStream].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kinesis&#46;kotlin&#46;inputs&#46;GetFirehoseDeliveryStreamPlainArgs].
     * @return A collection of values returned by getFirehoseDeliveryStream.
     */
    public suspend
    fun getFirehoseDeliveryStream(argument: suspend GetFirehoseDeliveryStreamPlainArgsBuilder.() -> Unit):
        GetFirehoseDeliveryStreamResult {
        val builder = GetFirehoseDeliveryStreamPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirehoseDeliveryStreamResultToKotlin(getFirehoseDeliveryStreamPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a Kinesis Stream for use in other
     * resources.
     * For more details, see the [Amazon Kinesis Documentation](https://aws.amazon.com/documentation/kinesis/).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kinesis.KinesisFunctions;
     * import com.pulumi.aws.kinesis.inputs.GetStreamArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var stream = KinesisFunctions.getStream(GetStreamArgs.builder()
     *             .name("stream-name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getStream.
     * @return A collection of values returned by getStream.
     */
    public suspend fun getStream(argument: GetStreamPlainArgs): GetStreamResult =
        getStreamResultToKotlin(getStreamPlain(argument.toJava()).await())

    /**
     * @see [getStream].
     * @param name Name of the Kinesis Stream.
     * @param tags Map of tags to assigned to the stream.
     * @return A collection of values returned by getStream.
     */
    public suspend fun getStream(name: String, tags: Map<String, String>? = null): GetStreamResult {
        val argument = GetStreamPlainArgs(
            name = name,
            tags = tags,
        )
        return getStreamResultToKotlin(getStreamPlain(argument.toJava()).await())
    }

    /**
     * @see [getStream].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kinesis&#46;kotlin&#46;inputs&#46;GetStreamPlainArgs].
     * @return A collection of values returned by getStream.
     */
    public suspend fun getStream(argument: suspend GetStreamPlainArgsBuilder.() -> Unit):
        GetStreamResult {
        val builder = GetStreamPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStreamResultToKotlin(getStreamPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a Kinesis Stream Consumer.
     * For more details, see the [Amazon Kinesis Stream Consumer Documentation](https://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-consumers.html).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.kinesis.KinesisFunctions;
     * import com.pulumi.aws.kinesis.inputs.GetStreamConsumerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = KinesisFunctions.getStreamConsumer(GetStreamConsumerArgs.builder()
     *             .name("example-consumer")
     *             .streamArn(aws_kinesis_stream.example().arn())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getStreamConsumer.
     * @return A collection of values returned by getStreamConsumer.
     */
    public suspend fun getStreamConsumer(argument: GetStreamConsumerPlainArgs):
        GetStreamConsumerResult =
        getStreamConsumerResultToKotlin(getStreamConsumerPlain(argument.toJava()).await())

    /**
     * @see [getStreamConsumer].
     * @param arn ARN of the stream consumer.
     * @param name Name of the stream consumer.
     * @param streamArn ARN of the data stream the consumer is registered with.
     * @return A collection of values returned by getStreamConsumer.
     */
    public suspend fun getStreamConsumer(
        arn: String? = null,
        name: String? = null,
        streamArn: String,
    ): GetStreamConsumerResult {
        val argument = GetStreamConsumerPlainArgs(
            arn = arn,
            name = name,
            streamArn = streamArn,
        )
        return getStreamConsumerResultToKotlin(getStreamConsumerPlain(argument.toJava()).await())
    }

    /**
     * @see [getStreamConsumer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kinesis&#46;kotlin&#46;inputs&#46;GetStreamConsumerPlainArgs].
     * @return A collection of values returned by getStreamConsumer.
     */
    public suspend
    fun getStreamConsumer(argument: suspend GetStreamConsumerPlainArgsBuilder.() -> Unit):
        GetStreamConsumerResult {
        val builder = GetStreamConsumerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStreamConsumerResultToKotlin(getStreamConsumerPlain(builtArgument.toJava()).await())
    }
}
