@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.StreamArgs.builder
import com.pulumi.aws.kinesis.kotlin.inputs.StreamStreamModeDetailsArgs
import com.pulumi.aws.kinesis.kotlin.inputs.StreamStreamModeDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Kinesis Stream resource. Amazon Kinesis is a managed service that
 * scales elastically for real-time processing of streaming big data.
 * For more details, see the [Amazon Kinesis Documentation](https://aws.amazon.com/documentation/kinesis/).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.inputs.StreamStreamModeDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testStream = new Stream("testStream", StreamArgs.builder()
 *             .retentionPeriod(48)
 *             .shardCount(1)
 *             .shardLevelMetrics(
 *                 "IncomingBytes",
 *                 "OutgoingBytes")
 *             .streamModeDetails(StreamStreamModeDetailsArgs.builder()
 *                 .streamMode("PROVISIONED")
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Streams using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/stream:Stream test_stream pulumi-kinesis-test
 * ```
 * @property arn The Amazon Resource Name (ARN) specifying the Stream (same as `id`)
 * @property encryptionType The encryption type to use. The only acceptable values are `NONE` or `KMS`. The default value is `NONE`.
 * @property enforceConsumerDeletion A boolean that indicates all registered consumers should be deregistered from the stream so that the stream can be destroyed without error. The default value is `false`.
 * @property kmsKeyId The GUID for the customer-managed KMS key to use for encryption. You can also use a Kinesis-owned master key by specifying the alias `alias/aws/kinesis`.
 * @property name A name to identify the stream. This is unique to the AWS account and region the Stream is created in.
 * @property retentionPeriod Length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 8760 hours. Minimum value is 24. Default is 24.
 * @property shardCount The number of shards that the stream will use. If the `stream_mode` is `PROVISIONED`, this field is required.
 * Amazon has guidelines for specifying the Stream size that should be referenced when creating a Kinesis stream. See [Amazon Kinesis Streams](https://docs.aws.amazon.com/kinesis/latest/dev/amazon-kinesis-streams.html) for more.
 * @property shardLevelMetrics A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
 * @property streamModeDetails Indicates the [capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StreamArgs(
    public val arn: Output<String>? = null,
    public val encryptionType: Output<String>? = null,
    public val enforceConsumerDeletion: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val shardCount: Output<Int>? = null,
    public val shardLevelMetrics: Output<List<String>>? = null,
    public val streamModeDetails: Output<StreamStreamModeDetailsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.StreamArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.StreamArgs =
        com.pulumi.aws.kinesis.StreamArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .encryptionType(encryptionType?.applyValue({ args0 -> args0 }))
            .enforceConsumerDeletion(enforceConsumerDeletion?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 }))
            .shardLevelMetrics(shardLevelMetrics?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .streamModeDetails(streamModeDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StreamArgs].
 */
@PulumiTagMarker
public class StreamArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var encryptionType: Output<String>? = null

    private var enforceConsumerDeletion: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    private var shardCount: Output<Int>? = null

    private var shardLevelMetrics: Output<List<String>>? = null

    private var streamModeDetails: Output<StreamStreamModeDetailsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream (same as `id`)
     */
    @JvmName("qdjaqasyeoymgahg")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The encryption type to use. The only acceptable values are `NONE` or `KMS`. The default value is `NONE`.
     */
    @JvmName("iqiaudjldygscwya")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value A boolean that indicates all registered consumers should be deregistered from the stream so that the stream can be destroyed without error. The default value is `false`.
     */
    @JvmName("dkldjsujdyskpwru")
    public suspend fun enforceConsumerDeletion(`value`: Output<Boolean>) {
        this.enforceConsumerDeletion = value
    }

    /**
     * @param value The GUID for the customer-managed KMS key to use for encryption. You can also use a Kinesis-owned master key by specifying the alias `alias/aws/kinesis`.
     */
    @JvmName("ogtvlsfdoxxiomav")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in.
     */
    @JvmName("resnqufebmpdqmec")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 8760 hours. Minimum value is 24. Default is 24.
     */
    @JvmName("xrpbwgqqdprjprbd")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value The number of shards that the stream will use. If the `stream_mode` is `PROVISIONED`, this field is required.
     * Amazon has guidelines for specifying the Stream size that should be referenced when creating a Kinesis stream. See [Amazon Kinesis Streams](https://docs.aws.amazon.com/kinesis/latest/dev/amazon-kinesis-streams.html) for more.
     */
    @JvmName("tmjuyrisjnpyarug")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
     */
    @JvmName("ixungtubqyfdfxeo")
    public suspend fun shardLevelMetrics(`value`: Output<List<String>>) {
        this.shardLevelMetrics = value
    }

    @JvmName("yesntpicoxahqysc")
    public suspend fun shardLevelMetrics(vararg values: Output<String>) {
        this.shardLevelMetrics = Output.all(values.asList())
    }

    /**
     * @param values A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
     */
    @JvmName("xkefonjjnukejonk")
    public suspend fun shardLevelMetrics(values: List<Output<String>>) {
        this.shardLevelMetrics = Output.all(values)
    }

    /**
     * @param value Indicates the [capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
     */
    @JvmName("omcdlsnpvnlbhthf")
    public suspend fun streamModeDetails(`value`: Output<StreamStreamModeDetailsArgs>) {
        this.streamModeDetails = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgmuakcsshuxoggu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) specifying the Stream (same as `id`)
     */
    @JvmName("hyxwkmoupmegwata")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The encryption type to use. The only acceptable values are `NONE` or `KMS`. The default value is `NONE`.
     */
    @JvmName("stlubyxecwtspevy")
    public suspend fun encryptionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value A boolean that indicates all registered consumers should be deregistered from the stream so that the stream can be destroyed without error. The default value is `false`.
     */
    @JvmName("rmywrkrtrjpyymih")
    public suspend fun enforceConsumerDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceConsumerDeletion = mapped
    }

    /**
     * @param value The GUID for the customer-managed KMS key to use for encryption. You can also use a Kinesis-owned master key by specifying the alias `alias/aws/kinesis`.
     */
    @JvmName("rpatrgmjipikaiyl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A name to identify the stream. This is unique to the AWS account and region the Stream is created in.
     */
    @JvmName("tmkjukmjnbelrpti")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Length of time data records are accessible after they are added to the stream. The maximum value of a stream's retention period is 8760 hours. Minimum value is 24. Default is 24.
     */
    @JvmName("bbydvnqlecrypgmr")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value The number of shards that the stream will use. If the `stream_mode` is `PROVISIONED`, this field is required.
     * Amazon has guidelines for specifying the Stream size that should be referenced when creating a Kinesis stream. See [Amazon Kinesis Streams](https://docs.aws.amazon.com/kinesis/latest/dev/amazon-kinesis-streams.html) for more.
     */
    @JvmName("ijxpmhwmdehwfnur")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    /**
     * @param value A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
     */
    @JvmName("gukfmytedavkqgvu")
    public suspend fun shardLevelMetrics(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardLevelMetrics = mapped
    }

    /**
     * @param values A list of shard-level CloudWatch metrics which can be enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more. Note that the value ALL should not be used; instead you should provide an explicit list of metrics you wish to enable.
     */
    @JvmName("flrrcbcurtuyuhil")
    public suspend fun shardLevelMetrics(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.shardLevelMetrics = mapped
    }

    /**
     * @param value Indicates the [capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
     */
    @JvmName("kvscqiocqdxyevqw")
    public suspend fun streamModeDetails(`value`: StreamStreamModeDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamModeDetails = mapped
    }

    /**
     * @param argument Indicates the [capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
     */
    @JvmName("amsfshspathxpcxj")
    public suspend
    fun streamModeDetails(argument: suspend StreamStreamModeDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = StreamStreamModeDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.streamModeDetails = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hshnngpvdaayuobx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rnnewuyojlrlqpct")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StreamArgs = StreamArgs(
        arn = arn,
        encryptionType = encryptionType,
        enforceConsumerDeletion = enforceConsumerDeletion,
        kmsKeyId = kmsKeyId,
        name = name,
        retentionPeriod = retentionPeriod,
        shardCount = shardCount,
        shardLevelMetrics = shardLevelMetrics,
        streamModeDetails = streamModeDetails,
        tags = tags,
    )
}
