@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.StreamConsumerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a Kinesis Stream Consumer.
 * > **Note:** You can register up to 20 consumers per stream. A given consumer can only be registered with one stream at a time.
 * For more details, see the [Amazon Kinesis Stream Consumer Documentation](https://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-consumers.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.Stream;
 * import com.pulumi.aws.kinesis.StreamArgs;
 * import com.pulumi.aws.kinesis.StreamConsumer;
 * import com.pulumi.aws.kinesis.StreamConsumerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleStream = new Stream("exampleStream", StreamArgs.builder()
 *             .shardCount(1)
 *             .build());
 *         var exampleStreamConsumer = new StreamConsumer("exampleStreamConsumer", StreamConsumerArgs.builder()
 *             .streamArn(exampleStream.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Stream Consumers using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:kinesis/streamConsumer:StreamConsumer example arn:aws:kinesis:us-west-2:123456789012:stream/example/consumer/example:1616044553
 * ```
 * @property name Name of the stream consumer.
 * @property streamArn Amazon Resource Name (ARN) of the data stream the consumer is registered with.
 */
public data class StreamConsumerArgs(
    public val name: Output<String>? = null,
    public val streamArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.StreamConsumerArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.StreamConsumerArgs =
        com.pulumi.aws.kinesis.StreamConsumerArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .streamArn(streamArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamConsumerArgs].
 */
@PulumiTagMarker
public class StreamConsumerArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var streamArn: Output<String>? = null

    /**
     * @param value Name of the stream consumer.
     */
    @JvmName("fyqjqodrfkmhxhjp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the data stream the consumer is registered with.
     */
    @JvmName("ntcuregieaxbmupq")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value Name of the stream consumer.
     */
    @JvmName("tghjysinhnkfumxs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the data stream the consumer is registered with.
     */
    @JvmName("oseymkhrdibspmgw")
    public suspend fun streamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): StreamConsumerArgs = StreamConsumerArgs(
        name = name,
        streamArn = streamArn,
    )
}
