@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VideoStream].
 */
@PulumiTagMarker
public class VideoStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VideoStreamArgs = VideoStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VideoStreamArgsBuilder.() -> Unit) {
        val builder = VideoStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VideoStream {
        val builtJavaResource = com.pulumi.aws.kinesis.VideoStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VideoStream(builtJavaResource)
    }
}

/**
 * Provides a Kinesis Video Stream resource. Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing.
 * For more details, see the [Amazon Kinesis Documentation](https://aws.amazon.com/documentation/kinesis/).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.VideoStream;
 * import com.pulumi.aws.kinesis.VideoStreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VideoStream("default", VideoStreamArgs.builder()
 *             .dataRetentionInHours(1)
 *             .deviceName("kinesis-video-device-name")
 *             .mediaType("video/h264")
 *             .tags(Map.of("Name", "kinesis-video-stream"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Streams using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/videoStream:VideoStream test_stream arn:aws:kinesisvideo:us-west-2:123456789012:stream/pulumi-kinesis-test/1554978910975
 * ```
 *
 */
public class VideoStream internal constructor(
    override val javaResource: com.pulumi.aws.kinesis.VideoStream,
) : KotlinCustomResource(javaResource, VideoStreamMapper) {
    /**
     * The Amazon Resource Name (ARN) specifying the Stream (same as `id`)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A time stamp that indicates when the stream was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. The default value is `0`, indicating that the stream does not persist data.
     */
    public val dataRetentionInHours: Output<Int>?
        get() = javaResource.dataRetentionInHours().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the device that is writing to the stream. **In the current implementation, Kinesis Video Streams does not use this name.**
     */
    public val deviceName: Output<String>?
        get() = javaResource.deviceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www&#46;iana&#46;org/assignments/media-types/media-types&#46;xhtml)&#46; If you choose to specify the MediaType, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
     */
    public val mediaType: Output<String>?
        get() = javaResource.mediaType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A name to identify the stream. This is unique to the
     * AWS account and region the Stream is created in.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The version of the stream.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object VideoStreamMapper : ResourceMapper<VideoStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kinesis.VideoStream::class == javaResource::class

    override fun map(javaResource: Resource): VideoStream = VideoStream(
        javaResource as
            com.pulumi.aws.kinesis.VideoStream,
    )
}

/**
 * @see [VideoStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VideoStream].
 */
public suspend fun videoStream(name: String, block: suspend VideoStreamResourceBuilder.() -> Unit):
    VideoStream {
    val builder = VideoStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VideoStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun videoStream(name: String): VideoStream {
    val builder = VideoStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
