@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin

import com.pulumi.aws.kinesis.VideoStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Kinesis Video Stream resource. Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing.
 * For more details, see the [Amazon Kinesis Documentation](https://aws.amazon.com/documentation/kinesis/).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesis.VideoStream;
 * import com.pulumi.aws.kinesis.VideoStreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VideoStream("default", VideoStreamArgs.builder()
 *             .dataRetentionInHours(1)
 *             .deviceName("kinesis-video-device-name")
 *             .mediaType("video/h264")
 *             .tags(Map.of("Name", "kinesis-video-stream"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Kinesis Streams using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:kinesis/videoStream:VideoStream test_stream arn:aws:kinesisvideo:us-west-2:123456789012:stream/pulumi-kinesis-test/1554978910975
 * ```
 * @property dataRetentionInHours The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. The default value is `0`, indicating that the stream does not persist data.
 * @property deviceName The name of the device that is writing to the stream. **In the current implementation, Kinesis Video Streams does not use this name.**
 * @property kmsKeyId The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
 * @property mediaType The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www&#46;iana&#46;org/assignments/media-types/media-types&#46;xhtml)&#46; If you choose to specify the MediaType, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
 * @property name A name to identify the stream. This is unique to the
 * AWS account and region the Stream is created in.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VideoStreamArgs(
    public val dataRetentionInHours: Output<Int>? = null,
    public val deviceName: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val mediaType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.VideoStreamArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.VideoStreamArgs =
        com.pulumi.aws.kinesis.VideoStreamArgs.builder()
            .dataRetentionInHours(dataRetentionInHours?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .mediaType(mediaType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VideoStreamArgs].
 */
@PulumiTagMarker
public class VideoStreamArgsBuilder internal constructor() {
    private var dataRetentionInHours: Output<Int>? = null

    private var deviceName: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var mediaType: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. The default value is `0`, indicating that the stream does not persist data.
     */
    @JvmName("kbxsrbvnedhytrgd")
    public suspend fun dataRetentionInHours(`value`: Output<Int>) {
        this.dataRetentionInHours = value
    }

    /**
     * @param value The name of the device that is writing to the stream. **In the current implementation, Kinesis Video Streams does not use this name.**
     */
    @JvmName("ejyapuhrfltlkojb")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
     */
    @JvmName("natimdeuegfbeljb")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www&#46;iana&#46;org/assignments/media-types/media-types&#46;xhtml)&#46; If you choose to specify the MediaType, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
     */
    @JvmName("ldcnootdfdepjvuk")
    public suspend fun mediaType(`value`: Output<String>) {
        this.mediaType = value
    }

    /**
     * @param value A name to identify the stream. This is unique to the
     * AWS account and region the Stream is created in.
     */
    @JvmName("tigyonrlguglwgcg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lmjvmuyxbgjxaeib")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. The default value is `0`, indicating that the stream does not persist data.
     */
    @JvmName("dljjjebqosihjnxc")
    public suspend fun dataRetentionInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRetentionInHours = mapped
    }

    /**
     * @param value The name of the device that is writing to the stream. **In the current implementation, Kinesis Video Streams does not use this name.**
     */
    @JvmName("uwceqktkdpelqufh")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
     */
    @JvmName("xrqeuovjwkhhsfhb")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www&#46;iana&#46;org/assignments/media-types/media-types&#46;xhtml)&#46; If you choose to specify the MediaType, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
     */
    @JvmName("usxkkskhkehwdgta")
    public suspend fun mediaType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaType = mapped
    }

    /**
     * @param value A name to identify the stream. This is unique to the
     * AWS account and region the Stream is created in.
     */
    @JvmName("hfxymryecdirqdet")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("roopwyomyecudrsu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nejpluwmqxggixqj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VideoStreamArgs = VideoStreamArgs(
        dataRetentionInHours = dataRetentionInHours,
        deviceName = deviceName,
        kmsKeyId = kmsKeyId,
        mediaType = mediaType,
        name = name,
        tags = tags,
    )
}
