@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property logStreamArn The ARN of the CloudWatch Log Stream.
 * @property roleArn The ARN of the IAM Role used to send application messages.
 */
public data class AnalyticsApplicationCloudwatchLoggingOptionsArgs(
    public val id: Output<String>? = null,
    public val logStreamArn: Output<String>,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationCloudwatchLoggingOptionsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .logStreamArn(logStreamArn.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationCloudwatchLoggingOptionsArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationCloudwatchLoggingOptionsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var logStreamArn: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("qthcqpxtbvjngqcm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The ARN of the CloudWatch Log Stream.
     */
    @JvmName("vkfkmmihvgnukdxu")
    public suspend fun logStreamArn(`value`: Output<String>) {
        this.logStreamArn = value
    }

    /**
     * @param value The ARN of the IAM Role used to send application messages.
     */
    @JvmName("ruqfmpxfhhvqupre")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("roqxodwsvdaaeusu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The ARN of the CloudWatch Log Stream.
     */
    @JvmName("balhqfcprkviwwgb")
    public suspend fun logStreamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreamArn = mapped
    }

    /**
     * @param value The ARN of the IAM Role used to send application messages.
     */
    @JvmName("gxolryrftafunnfi")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AnalyticsApplicationCloudwatchLoggingOptionsArgs =
        AnalyticsApplicationCloudwatchLoggingOptionsArgs(
            id = id,
            logStreamArn = logStreamArn ?: throw PulumiNullFieldException("logStreamArn"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
