@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property kinesisFirehose The Kinesis Firehose configuration for the streaming source. Conflicts with `kinesis_stream`.
 * See Kinesis Firehose below for more details.
 * @property kinesisStream The Kinesis Stream configuration for the streaming source. Conflicts with `kinesis_firehose`.
 * See Kinesis Stream below for more details.
 * @property namePrefix The Name Prefix to use when creating an in-application stream.
 * @property parallelism The number of Parallel in-application streams to create.
 * See Parallelism below for more details.
 * @property processingConfiguration The Processing Configuration to transform records as they are received from the stream.
 * See Processing Configuration below for more details.
 * @property schema The Schema format of the data in the streaming source. See Source Schema below for more details.
 * @property startingPositionConfigurations The point at which the application starts processing records from the streaming source.
 * See Starting Position Configuration below for more details.
 * @property streamNames
 */
public data class AnalyticsApplicationInputsArgs(
    public val id: Output<String>? = null,
    public val kinesisFirehose: Output<AnalyticsApplicationInputsKinesisFirehoseArgs>? = null,
    public val kinesisStream: Output<AnalyticsApplicationInputsKinesisStreamArgs>? = null,
    public val namePrefix: Output<String>,
    public val parallelism: Output<AnalyticsApplicationInputsParallelismArgs>? = null,
    public val processingConfiguration: Output<AnalyticsApplicationInputsProcessingConfigurationArgs>? =
        null,
    public val schema: Output<AnalyticsApplicationInputsSchemaArgs>,
    public val startingPositionConfigurations:
    Output<List<AnalyticsApplicationInputsStartingPositionConfigurationArgs>>? = null,
    public val streamNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .kinesisFirehose(kinesisFirehose?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kinesisStream(kinesisStream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namePrefix(namePrefix.applyValue({ args0 -> args0 }))
            .parallelism(parallelism?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schema(schema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startingPositionConfigurations(
                startingPositionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .streamNames(streamNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var kinesisFirehose: Output<AnalyticsApplicationInputsKinesisFirehoseArgs>? = null

    private var kinesisStream: Output<AnalyticsApplicationInputsKinesisStreamArgs>? = null

    private var namePrefix: Output<String>? = null

    private var parallelism: Output<AnalyticsApplicationInputsParallelismArgs>? = null

    private var processingConfiguration:
        Output<AnalyticsApplicationInputsProcessingConfigurationArgs>? = null

    private var schema: Output<AnalyticsApplicationInputsSchemaArgs>? = null

    private var startingPositionConfigurations:
        Output<List<AnalyticsApplicationInputsStartingPositionConfigurationArgs>>? = null

    private var streamNames: Output<List<String>>? = null

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("wjjwojwgelvxgnxe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The Kinesis Firehose configuration for the streaming source. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("hpsjsxafllnuflno")
    public suspend
    fun kinesisFirehose(`value`: Output<AnalyticsApplicationInputsKinesisFirehoseArgs>) {
        this.kinesisFirehose = value
    }

    /**
     * @param value The Kinesis Stream configuration for the streaming source. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("xsfoiutorbpjsssx")
    public suspend fun kinesisStream(`value`: Output<AnalyticsApplicationInputsKinesisStreamArgs>) {
        this.kinesisStream = value
    }

    /**
     * @param value The Name Prefix to use when creating an in-application stream.
     */
    @JvmName("wkhmhqujcbqdsfih")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The number of Parallel in-application streams to create.
     * See Parallelism below for more details.
     */
    @JvmName("yjlsaesxknplfjxs")
    public suspend fun parallelism(`value`: Output<AnalyticsApplicationInputsParallelismArgs>) {
        this.parallelism = value
    }

    /**
     * @param value The Processing Configuration to transform records as they are received from the stream.
     * See Processing Configuration below for more details.
     */
    @JvmName("jxbkpafrkmvgoqso")
    public suspend
    fun processingConfiguration(`value`: Output<AnalyticsApplicationInputsProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("wmstvyawswluafha")
    public suspend fun schema(`value`: Output<AnalyticsApplicationInputsSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("xlodsvqmyhaghlqp")
    public suspend
    fun startingPositionConfigurations(`value`: Output<List<AnalyticsApplicationInputsStartingPositionConfigurationArgs>>) {
        this.startingPositionConfigurations = value
    }

    @JvmName("aotkadxedmkgirso")
    public suspend fun startingPositionConfigurations(
        vararg
        values: Output<AnalyticsApplicationInputsStartingPositionConfigurationArgs>,
    ) {
        this.startingPositionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("pchiblxfvjifgdis")
    public suspend
    fun startingPositionConfigurations(values: List<Output<AnalyticsApplicationInputsStartingPositionConfigurationArgs>>) {
        this.startingPositionConfigurations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gercydqfchhfewgi")
    public suspend fun streamNames(`value`: Output<List<String>>) {
        this.streamNames = value
    }

    @JvmName("pluwsacmetnyvnet")
    public suspend fun streamNames(vararg values: Output<String>) {
        this.streamNames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jshatijmupyhrxme")
    public suspend fun streamNames(values: List<Output<String>>) {
        this.streamNames = Output.all(values)
    }

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("gsjttoqikdcfbpeq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The Kinesis Firehose configuration for the streaming source. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("udwvjrjmfgupmxoy")
    public suspend fun kinesisFirehose(`value`: AnalyticsApplicationInputsKinesisFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisFirehose = mapped
    }

    /**
     * @param argument The Kinesis Firehose configuration for the streaming source. Conflicts with `kinesis_stream`.
     * See Kinesis Firehose below for more details.
     */
    @JvmName("hnvkyjiqmsnrbktj")
    public suspend
    fun kinesisFirehose(argument: suspend AnalyticsApplicationInputsKinesisFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsKinesisFirehoseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisFirehose = mapped
    }

    /**
     * @param value The Kinesis Stream configuration for the streaming source. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("fypcxukkmwgalscs")
    public suspend fun kinesisStream(`value`: AnalyticsApplicationInputsKinesisStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStream = mapped
    }

    /**
     * @param argument The Kinesis Stream configuration for the streaming source. Conflicts with `kinesis_firehose`.
     * See Kinesis Stream below for more details.
     */
    @JvmName("dmcuherbbfklwosl")
    public suspend
    fun kinesisStream(argument: suspend AnalyticsApplicationInputsKinesisStreamArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsKinesisStreamArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kinesisStream = mapped
    }

    /**
     * @param value The Name Prefix to use when creating an in-application stream.
     */
    @JvmName("vqfxxvrjgcbmjafm")
    public suspend fun namePrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The number of Parallel in-application streams to create.
     * See Parallelism below for more details.
     */
    @JvmName("otchilbtxjprxdfn")
    public suspend fun parallelism(`value`: AnalyticsApplicationInputsParallelismArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param argument The number of Parallel in-application streams to create.
     * See Parallelism below for more details.
     */
    @JvmName("gengemrapjlvcxaq")
    public suspend
    fun parallelism(argument: suspend AnalyticsApplicationInputsParallelismArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsParallelismArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parallelism = mapped
    }

    /**
     * @param value The Processing Configuration to transform records as they are received from the stream.
     * See Processing Configuration below for more details.
     */
    @JvmName("mpjottyvlyjjiooq")
    public suspend
    fun processingConfiguration(`value`: AnalyticsApplicationInputsProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The Processing Configuration to transform records as they are received from the stream.
     * See Processing Configuration below for more details.
     */
    @JvmName("qwujvsrvfnbujneh")
    public suspend
    fun processingConfiguration(argument: suspend AnalyticsApplicationInputsProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsProcessingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("aqonqcrxcnhwjnpf")
    public suspend fun schema(`value`: AnalyticsApplicationInputsSchemaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("sjyqmbqeipfyfuhc")
    public suspend
    fun schema(argument: suspend AnalyticsApplicationInputsSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsSchemaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("nyefkiltcmctmxre")
    public suspend
    fun startingPositionConfigurations(`value`: List<AnalyticsApplicationInputsStartingPositionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("jwstfnqnjjljudnk")
    public suspend
    fun startingPositionConfigurations(argument: List<suspend AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.startingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("drmkprdseoinfnkj")
    public suspend fun startingPositionConfigurations(
        vararg
        argument: suspend AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.startingPositionConfigurations = mapped
    }

    /**
     * @param argument The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("bpwnfpedrtwuklxe")
    public suspend
    fun startingPositionConfigurations(argument: suspend AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.startingPositionConfigurations = mapped
    }

    /**
     * @param values The point at which the application starts processing records from the streaming source.
     * See Starting Position Configuration below for more details.
     */
    @JvmName("riwmxkpbehhroxxf")
    public suspend fun startingPositionConfigurations(
        vararg
        values: AnalyticsApplicationInputsStartingPositionConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startingPositionConfigurations = mapped
    }

    /**
     * @param value
     */
    @JvmName("gcilslubvlbrflap")
    public suspend fun streamNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("juersnbgquayflyu")
    public suspend fun streamNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamNames = mapped
    }

    internal fun build(): AnalyticsApplicationInputsArgs = AnalyticsApplicationInputsArgs(
        id = id,
        kinesisFirehose = kinesisFirehose,
        kinesisStream = kinesisStream,
        namePrefix = namePrefix ?: throw PulumiNullFieldException("namePrefix"),
        parallelism = parallelism,
        processingConfiguration = processingConfiguration,
        schema = schema ?: throw PulumiNullFieldException("schema"),
        startingPositionConfigurations = startingPositionConfigurations,
        streamNames = streamNames,
    )
}
