@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property count The Count of streams.
 */
public data class AnalyticsApplicationInputsParallelismArgs(
    public val count: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsParallelismArgs.builder()
            .count(count?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsParallelismArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsParallelismArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    /**
     * @param value The Count of streams.
     */
    @JvmName("gbgievbttyjhcyky")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The Count of streams.
     */
    @JvmName("egnfdfwregdfwdqh")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    internal fun build(): AnalyticsApplicationInputsParallelismArgs =
        AnalyticsApplicationInputsParallelismArgs(
            count = count,
        )
}
