@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property lambda The Lambda function configuration. See Lambda below for more details.
 */
public data class AnalyticsApplicationInputsProcessingConfigurationArgs(
    public val lambda: Output<AnalyticsApplicationInputsProcessingConfigurationLambdaArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsProcessingConfigurationArgs.builder()
            .lambda(lambda.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsProcessingConfigurationArgsBuilder internal constructor() {
    private var lambda: Output<AnalyticsApplicationInputsProcessingConfigurationLambdaArgs>? = null

    /**
     * @param value The Lambda function configuration. See Lambda below for more details.
     */
    @JvmName("emxpbdoyfrmstsyc")
    public suspend
    fun lambda(`value`: Output<AnalyticsApplicationInputsProcessingConfigurationLambdaArgs>) {
        this.lambda = value
    }

    /**
     * @param value The Lambda function configuration. See Lambda below for more details.
     */
    @JvmName("auwckyxfspxvyuaw")
    public suspend fun lambda(`value`: AnalyticsApplicationInputsProcessingConfigurationLambdaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lambda = mapped
    }

    /**
     * @param argument The Lambda function configuration. See Lambda below for more details.
     */
    @JvmName("cybhwnexdqjxgfud")
    public suspend
    fun lambda(argument: suspend AnalyticsApplicationInputsProcessingConfigurationLambdaArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationInputsProcessingConfigurationLambdaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.lambda = mapped
    }

    internal fun build(): AnalyticsApplicationInputsProcessingConfigurationArgs =
        AnalyticsApplicationInputsProcessingConfigurationArgs(
            lambda = lambda ?: throw PulumiNullFieldException("lambda"),
        )
}
