@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumns The Record Column mapping for the streaming source data element.
 * See Record Columns below for more details.
 * @property recordEncoding The Encoding of the record in the streaming source.
 * @property recordFormat The Record Format and mapping information to schematize a record.
 * See Record Format below for more details.
 */
public data class AnalyticsApplicationInputsSchemaArgs(
    public val recordColumns: Output<List<AnalyticsApplicationInputsSchemaRecordColumnArgs>>,
    public val recordEncoding: Output<String>? = null,
    public val recordFormat: Output<AnalyticsApplicationInputsSchemaRecordFormatArgs>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaArgs.builder()
            .recordColumns(
                recordColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordEncoding(recordEncoding?.applyValue({ args0 -> args0 }))
            .recordFormat(recordFormat.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaArgsBuilder internal constructor() {
    private var recordColumns: Output<List<AnalyticsApplicationInputsSchemaRecordColumnArgs>>? = null

    private var recordEncoding: Output<String>? = null

    private var recordFormat: Output<AnalyticsApplicationInputsSchemaRecordFormatArgs>? = null

    /**
     * @param value The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("orrpdnwndebnnspf")
    public suspend
    fun recordColumns(`value`: Output<List<AnalyticsApplicationInputsSchemaRecordColumnArgs>>) {
        this.recordColumns = value
    }

    @JvmName("gfusbkcwnkanrnpe")
    public suspend fun recordColumns(
        vararg
        values: Output<AnalyticsApplicationInputsSchemaRecordColumnArgs>,
    ) {
        this.recordColumns = Output.all(values.asList())
    }

    /**
     * @param values The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("cttjksbrbphgjcuo")
    public suspend
    fun recordColumns(values: List<Output<AnalyticsApplicationInputsSchemaRecordColumnArgs>>) {
        this.recordColumns = Output.all(values)
    }

    /**
     * @param value The Encoding of the record in the streaming source.
     */
    @JvmName("apppwwcmyoecqqdy")
    public suspend fun recordEncoding(`value`: Output<String>) {
        this.recordEncoding = value
    }

    /**
     * @param value The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("gwuljlwakedsghrl")
    public suspend
    fun recordFormat(`value`: Output<AnalyticsApplicationInputsSchemaRecordFormatArgs>) {
        this.recordFormat = value
    }

    /**
     * @param value The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("uhatviadelcjaeyp")
    public suspend
    fun recordColumns(`value`: List<AnalyticsApplicationInputsSchemaRecordColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("vsyymevhuftpmlhp")
    public suspend
    fun recordColumns(argument: List<suspend AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("jplscdiyjopkbooj")
    public suspend fun recordColumns(
        vararg
        argument: suspend AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("nqnhiurilwyaykyp")
    public suspend
    fun recordColumns(argument: suspend AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalyticsApplicationInputsSchemaRecordColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param values The Record Column mapping for the streaming source data element.
     * See Record Columns below for more details.
     */
    @JvmName("ampdmxnphdvvpbgc")
    public suspend fun recordColumns(
        vararg
        values: AnalyticsApplicationInputsSchemaRecordColumnArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param value The Encoding of the record in the streaming source.
     */
    @JvmName("vsriygywvwvnuxmp")
    public suspend fun recordEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordEncoding = mapped
    }

    /**
     * @param value The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("rahnkijatrkathjs")
    public suspend fun recordFormat(`value`: AnalyticsApplicationInputsSchemaRecordFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormat = mapped
    }

    /**
     * @param argument The Record Format and mapping information to schematize a record.
     * See Record Format below for more details.
     */
    @JvmName("xugksnreujaahxfy")
    public suspend
    fun recordFormat(argument: suspend AnalyticsApplicationInputsSchemaRecordFormatArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationInputsSchemaRecordFormatArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.recordFormat = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaArgs = AnalyticsApplicationInputsSchemaArgs(
        recordColumns = recordColumns ?: throw PulumiNullFieldException("recordColumns"),
        recordEncoding = recordEncoding,
        recordFormat = recordFormat ?: throw PulumiNullFieldException("recordFormat"),
    )
}
