@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property mappingParameters The Mapping Information for the record format.
 * See Mapping Parameters below for more details.
 * @property recordFormatType The type of Record Format. Can be `CSV` or `JSON`.
 */
public data class AnalyticsApplicationInputsSchemaRecordFormatArgs(
    public val mappingParameters:
    Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs>? = null,
    public val recordFormatType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatArgs.builder()
            .mappingParameters(mappingParameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recordFormatType(recordFormatType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaRecordFormatArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaRecordFormatArgsBuilder internal constructor() {
    private var mappingParameters:
        Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs>? = null

    private var recordFormatType: Output<String>? = null

    /**
     * @param value The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("thtwkuklmeetjchh")
    public suspend
    fun mappingParameters(`value`: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs>) {
        this.mappingParameters = value
    }

    /**
     * @param value The type of Record Format. Can be `CSV` or `JSON`.
     */
    @JvmName("rvhebvhxdngeunuw")
    public suspend fun recordFormatType(`value`: Output<String>) {
        this.recordFormatType = value
    }

    /**
     * @param value The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("kbsjlhoablvclvsm")
    public suspend
    fun mappingParameters(`value`: AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingParameters = mapped
    }

    /**
     * @param argument The Mapping Information for the record format.
     * See Mapping Parameters below for more details.
     */
    @JvmName("maflqkvnkqltfvae")
    public suspend
    fun mappingParameters(argument: suspend AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mappingParameters = mapped
    }

    /**
     * @param value The type of Record Format. Can be `CSV` or `JSON`.
     */
    @JvmName("liqadfdoxomgruft")
    public suspend fun recordFormatType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordFormatType = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaRecordFormatArgs =
        AnalyticsApplicationInputsSchemaRecordFormatArgs(
            mappingParameters = mappingParameters,
            recordFormatType = recordFormatType,
        )
}
