@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csv Mapping information when the record format uses delimiters.
 * See CSV Mapping Parameters below for more details.
 * @property json Mapping information when JSON is the record format on the streaming source.
 * See JSON Mapping Parameters below for more details.
 */
public data class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs(
    public val csv: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs>? =
        null,
    public val json: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs.builder()
            .csv(csv?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .json(json?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgsBuilder internal
constructor() {
    private var csv: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs>? =
        null

    private var json: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs>? =
        null

    /**
     * @param value Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("ltllatyaupitcfeq")
    public suspend
    fun csv(`value`: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs>) {
        this.csv = value
    }

    /**
     * @param value Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("ftcbaxwxghcqsmkl")
    public suspend
    fun json(`value`: Output<AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs>) {
        this.json = value
    }

    /**
     * @param value Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("roxljcntcbywwvrn")
    public suspend
    fun csv(`value`: AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csv = mapped
    }

    /**
     * @param argument Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("lvrewdvycrwnaijd")
    public suspend
    fun csv(argument: suspend AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.csv = mapped
    }

    /**
     * @param value Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("csddcivvfnrorbty")
    public suspend
    fun json(`value`: AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.json = mapped
    }

    /**
     * @param argument Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("emfehgyioknfpvcs")
    public suspend
    fun json(argument: suspend AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationInputsSchemaRecordFormatMappingParametersJsonArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.json = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs =
        AnalyticsApplicationInputsSchemaRecordFormatMappingParametersArgs(
            csv = csv,
            json = json,
        )
}
