@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumnDelimiter The Column Delimiter.
 * @property recordRowDelimiter The Row Delimiter.
 */
public data class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs(
    public val recordColumnDelimiter: Output<String>,
    public val recordRowDelimiter: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs.builder()
            .recordColumnDelimiter(recordColumnDelimiter.applyValue({ args0 -> args0 }))
            .recordRowDelimiter(recordRowDelimiter.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgsBuilder internal
constructor() {
    private var recordColumnDelimiter: Output<String>? = null

    private var recordRowDelimiter: Output<String>? = null

    /**
     * @param value The Column Delimiter.
     */
    @JvmName("dxrxwbcyceocvrvl")
    public suspend fun recordColumnDelimiter(`value`: Output<String>) {
        this.recordColumnDelimiter = value
    }

    /**
     * @param value The Row Delimiter.
     */
    @JvmName("ovjdsgsktmuhrsyu")
    public suspend fun recordRowDelimiter(`value`: Output<String>) {
        this.recordRowDelimiter = value
    }

    /**
     * @param value The Column Delimiter.
     */
    @JvmName("owsmtsmvkitbdvoq")
    public suspend fun recordColumnDelimiter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumnDelimiter = mapped
    }

    /**
     * @param value The Row Delimiter.
     */
    @JvmName("pswwohnkqglhvuwa")
    public suspend fun recordRowDelimiter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordRowDelimiter = mapped
    }

    internal fun build(): AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs =
        AnalyticsApplicationInputsSchemaRecordFormatMappingParametersCsvArgs(
            recordColumnDelimiter = recordColumnDelimiter ?: throw
                PulumiNullFieldException("recordColumnDelimiter"),
            recordRowDelimiter = recordRowDelimiter ?: throw PulumiNullFieldException("recordRowDelimiter"),
        )
}
