@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsStartingPositionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property startingPosition The starting position on the stream. Valid values: `LAST_STOPPED_POINT`, `NOW`, `TRIM_HORIZON`.
 */
public data class AnalyticsApplicationInputsStartingPositionConfigurationArgs(
    public val startingPosition: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsStartingPositionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsStartingPositionConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationInputsStartingPositionConfigurationArgs.builder()
            .startingPosition(startingPosition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationInputsStartingPositionConfigurationArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationInputsStartingPositionConfigurationArgsBuilder internal
constructor() {
    private var startingPosition: Output<String>? = null

    /**
     * @param value The starting position on the stream. Valid values: `LAST_STOPPED_POINT`, `NOW`, `TRIM_HORIZON`.
     */
    @JvmName("cembotrevetiyjam")
    public suspend fun startingPosition(`value`: Output<String>) {
        this.startingPosition = value
    }

    /**
     * @param value The starting position on the stream. Valid values: `LAST_STOPPED_POINT`, `NOW`, `TRIM_HORIZON`.
     */
    @JvmName("tlullsvcdoeodukf")
    public suspend fun startingPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startingPosition = mapped
    }

    internal fun build(): AnalyticsApplicationInputsStartingPositionConfigurationArgs =
        AnalyticsApplicationInputsStartingPositionConfigurationArgs(
            startingPosition = startingPosition,
        )
}
