@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property id The ARN of the Kinesis Analytics Application.
 * @property s3 The S3 configuration for the reference data source. See S3 Reference below for more details.
 * @property schema The Schema format of the data in the streaming source. See Source Schema below for more details.
 * @property tableName The in-application Table Name.
 */
public data class AnalyticsApplicationReferenceDataSourcesArgs(
    public val id: Output<String>? = null,
    public val s3: Output<AnalyticsApplicationReferenceDataSourcesS3Args>,
    public val schema: Output<AnalyticsApplicationReferenceDataSourcesSchemaArgs>,
    public val tableName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesArgs> {
    override fun toJava(): com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .s3(s3.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .schema(schema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationReferenceDataSourcesArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationReferenceDataSourcesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var s3: Output<AnalyticsApplicationReferenceDataSourcesS3Args>? = null

    private var schema: Output<AnalyticsApplicationReferenceDataSourcesSchemaArgs>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("ubmfubbghxsxbdwi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The S3 configuration for the reference data source. See S3 Reference below for more details.
     */
    @JvmName("godexuxicqrkbilb")
    public suspend fun s3(`value`: Output<AnalyticsApplicationReferenceDataSourcesS3Args>) {
        this.s3 = value
    }

    /**
     * @param value The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("ipgdytyaxnssoayw")
    public suspend fun schema(`value`: Output<AnalyticsApplicationReferenceDataSourcesSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The in-application Table Name.
     */
    @JvmName("rblongpishudeyoj")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The ARN of the Kinesis Analytics Application.
     */
    @JvmName("eftavicddqdcsmbu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The S3 configuration for the reference data source. See S3 Reference below for more details.
     */
    @JvmName("xxuqgmixlhpoessl")
    public suspend fun s3(`value`: AnalyticsApplicationReferenceDataSourcesS3Args) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument The S3 configuration for the reference data source. See S3 Reference below for more details.
     */
    @JvmName("jspwroxlnruqswfe")
    public suspend
    fun s3(argument: suspend AnalyticsApplicationReferenceDataSourcesS3ArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationReferenceDataSourcesS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("pweqpigfjqokjmgw")
    public suspend fun schema(`value`: AnalyticsApplicationReferenceDataSourcesSchemaArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The Schema format of the data in the streaming source. See Source Schema below for more details.
     */
    @JvmName("ssxuaxpwgbwejkac")
    public suspend
    fun schema(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = AnalyticsApplicationReferenceDataSourcesSchemaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value The in-application Table Name.
     */
    @JvmName("gpakxbxdmwgmxntr")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): AnalyticsApplicationReferenceDataSourcesArgs =
        AnalyticsApplicationReferenceDataSourcesArgs(
            id = id,
            s3 = s3 ?: throw PulumiNullFieldException("s3"),
            schema = schema ?: throw PulumiNullFieldException("schema"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        )
}
