@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The S3 Bucket ARN.
 * @property fileKey The File Key name containing reference data.
 * @property roleArn The ARN of the IAM Role used to send application messages.
 */
public data class AnalyticsApplicationReferenceDataSourcesS3Args(
    public val bucketArn: Output<String>,
    public val fileKey: Output<String>,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesS3Args> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesS3Args =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesS3Args.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .fileKey(fileKey.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalyticsApplicationReferenceDataSourcesS3Args].
 */
@PulumiTagMarker
public class AnalyticsApplicationReferenceDataSourcesS3ArgsBuilder internal constructor() {
    private var bucketArn: Output<String>? = null

    private var fileKey: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The S3 Bucket ARN.
     */
    @JvmName("qwkdjckupmaawbmt")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value The File Key name containing reference data.
     */
    @JvmName("khenpkbpoqtmhtgk")
    public suspend fun fileKey(`value`: Output<String>) {
        this.fileKey = value
    }

    /**
     * @param value The ARN of the IAM Role used to send application messages.
     */
    @JvmName("anesqysxwxkxcnpp")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The S3 Bucket ARN.
     */
    @JvmName("hjwgmprytspufhie")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value The File Key name containing reference data.
     */
    @JvmName("jbkpansogyypraem")
    public suspend fun fileKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileKey = mapped
    }

    /**
     * @param value The ARN of the IAM Role used to send application messages.
     */
    @JvmName("wwyuhlmnxxtafafb")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): AnalyticsApplicationReferenceDataSourcesS3Args =
        AnalyticsApplicationReferenceDataSourcesS3Args(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            fileKey = fileKey ?: throw PulumiNullFieldException("fileKey"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
