@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csv Mapping information when the record format uses delimiters.
 * See CSV Mapping Parameters below for more details.
 * @property json Mapping information when JSON is the record format on the streaming source.
 * See JSON Mapping Parameters below for more details.
 */
public data class AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs(
    public val csv:
    Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgs>? =
        null,
    public val json:
    Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs =
        com.pulumi.aws.kinesis.inputs.AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs.builder()
            .csv(csv?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .json(json?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs].
 */
@PulumiTagMarker
public class AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgsBuilder
internal constructor() {
    private var csv:
        Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgs>? =
        null

    private var json:
        Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgs>? =
        null

    /**
     * @param value Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("bcracofxlaryscvh")
    public suspend
    fun csv(`value`: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgs>) {
        this.csv = value
    }

    /**
     * @param value Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("teahppurlgwhutoo")
    public suspend
    fun json(`value`: Output<AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgs>) {
        this.json = value
    }

    /**
     * @param value Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("wbhttiognjgpndid")
    public suspend
    fun csv(`value`: AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csv = mapped
    }

    /**
     * @param argument Mapping information when the record format uses delimiters.
     * See CSV Mapping Parameters below for more details.
     */
    @JvmName("ebpnativxddqopdj")
    public suspend
    fun csv(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersCsvArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.csv = mapped
    }

    /**
     * @param value Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("wmnnvphwheoodhug")
    public suspend
    fun json(`value`: AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.json = mapped
    }

    /**
     * @param argument Mapping information when JSON is the record format on the streaming source.
     * See JSON Mapping Parameters below for more details.
     */
    @JvmName("efyxtoiusyqxaipk")
    public suspend
    fun json(argument: suspend AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgsBuilder.() -> Unit) {
        val toBeMapped =
            AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersJsonArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.json = mapped
    }

    internal fun build():
        AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs =
        AnalyticsApplicationReferenceDataSourcesSchemaRecordFormatMappingParametersArgs(
            csv = csv,
            json = json,
        )
}
