@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables data processing.
 * @property processors Array of data processors. More details are given below
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val processors:
    Output<List<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .processors(
                processors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var processors:
        Output<List<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>>? =
        null

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("opiihidvwgtxpuud")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("bycabelvewvksevn")
    public suspend
    fun processors(`value`: Output<List<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = value
    }

    @JvmName("jqvtrhxptsyiisxy")
    public suspend fun processors(
        vararg
        values: Output<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>,
    ) {
        this.processors = Output.all(values.asList())
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("kyqxawoihqaxncvx")
    public suspend
    fun processors(values: List<Output<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>>) {
        this.processors = Output.all(values)
    }

    /**
     * @param value Enables or disables data processing.
     */
    @JvmName("erjffvuajfnutwlg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of data processors. More details are given below
     */
    @JvmName("sluigeyashbeuepf")
    public suspend
    fun processors(`value`: List<FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("inxcqjbxjxaeouax")
    public suspend
    fun processors(argument: List<suspend FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("fsexyhdabussxeyj")
    public suspend fun processors(
        vararg
        argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param argument Array of data processors. More details are given below
     */
    @JvmName("whskjewweyyhygnw")
    public suspend
    fun processors(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.processors = mapped
    }

    /**
     * @param values Array of data processors. More details are given below
     */
    @JvmName("bsoxeltjviljgapr")
    public suspend fun processors(
        vararg
        values: FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationProcessorArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processors = mapped
    }

    internal fun build(): FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs =
        FirehoseDeliveryStreamElasticsearchConfigurationProcessingConfigurationArgs(
            enabled = enabled,
            processors = processors,
        )
}
