@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The ARN of the S3 bucket
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property compressionFormat The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
 * @property errorOutputPrefix Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
 * @property kmsKeyArn Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
 * be used.
 * @property prefix The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
 * @property roleArn The ARN of the role used to access the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs(
    public val bucketArn: Output<String>,
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions:
    Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgs>? =
        null,
    public val compressionFormat: Output<String>? = null,
    public val errorOutputPrefix: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .compressionFormat(compressionFormat?.applyValue({ args0 -> args0 }))
            .errorOutputPrefix(errorOutputPrefix?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgsBuilder internal
constructor() {
    private var bucketArn: Output<String>? = null

    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgs>? =
        null

    private var compressionFormat: Output<String>? = null

    private var errorOutputPrefix: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var prefix: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value The ARN of the S3 bucket
     */
    @JvmName("daobudguxxmfdftv")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("qffyuoecjabqvxan")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("vpggbmkbuxvwjeep")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("kqfigbrjawikwbjh")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
     */
    @JvmName("briowkoqwpopbqca")
    public suspend fun compressionFormat(`value`: Output<String>) {
        this.compressionFormat = value
    }

    /**
     * @param value Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    @JvmName("dhffmlvvdtlmggjj")
    public suspend fun errorOutputPrefix(`value`: Output<String>) {
        this.errorOutputPrefix = value
    }

    /**
     * @param value Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
     * be used.
     */
    @JvmName("csfmdqdyfnxkvlne")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
     */
    @JvmName("lsynangtswwoasoc")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("snoqjxjqjmixfave")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The ARN of the S3 bucket
     */
    @JvmName("euqouwkbjcwkqrpk")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("csccqpqrhdrcaxdi")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("cruficfwhyrpkewa")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("sxmfpbsijfcoskvg")
    public suspend
    fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("hmmngqcobyaoqdba")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
     */
    @JvmName("lwewbeutkakrurig")
    public suspend fun compressionFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionFormat = mapped
    }

    /**
     * @param value Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    @JvmName("tbdixqttqpilfjpa")
    public suspend fun errorOutputPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorOutputPrefix = mapped
    }

    /**
     * @param value Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
     * be used.
     */
    @JvmName("awhdfxviuelkkcea")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
     */
    @JvmName("mkrfttdiwjevgbss")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("dytqvfxrdofqssiq")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs =
        FirehoseDeliveryStreamElasticsearchConfigurationS3ConfigurationArgs(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            compressionFormat = compressionFormat,
            errorOutputPrefix = errorOutputPrefix,
            kmsKeyArn = kmsKeyArn,
            prefix = prefix,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        )
}
