@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The ARN of the S3 bucket
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. More details are given below
 * @property compressionFormat The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
 * @property dataFormatConversionConfiguration Nested argument for the serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3. More details given below.
 * @property dynamicPartitioningConfiguration The configuration for dynamic partitioning. See Dynamic Partitioning Configuration below for more details. Required when using dynamic partitioning.
 * @property errorOutputPrefix Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
 * @property kmsKeyArn Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
 * be used.
 * @property prefix The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
 * @property processingConfiguration The data processing configuration.  More details are given below.
 * @property roleArn The ARN of the role used to access the Amazon MSK cluster.
 * @property s3BackupConfiguration The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationArgs(
    public val bucketArn: Output<String>,
    public val bufferingInterval: Output<Int>? = null,
    public val bufferingSize: Output<Int>? = null,
    public val cloudwatchLoggingOptions:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgs>? = null,
    public val compressionFormat: Output<String>? = null,
    public val dataFormatConversionConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs>? =
        null,
    public val dynamicPartitioningConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs>? =
        null,
    public val errorOutputPrefix: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val processingConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs>? = null,
    public val roleArn: Output<String>,
    public val s3BackupConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgs>? = null,
    public val s3BackupMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .bufferingInterval(bufferingInterval?.applyValue({ args0 -> args0 }))
            .bufferingSize(bufferingSize?.applyValue({ args0 -> args0 }))
            .cloudwatchLoggingOptions(
                cloudwatchLoggingOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .compressionFormat(compressionFormat?.applyValue({ args0 -> args0 }))
            .dataFormatConversionConfiguration(
                dataFormatConversionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .dynamicPartitioningConfiguration(
                dynamicPartitioningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .errorOutputPrefix(errorOutputPrefix?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .processingConfiguration(
                processingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .s3BackupConfiguration(
                s3BackupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3BackupMode(s3BackupMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationArgs].
 */
@PulumiTagMarker
public class FirehoseDeliveryStreamExtendedS3ConfigurationArgsBuilder internal constructor() {
    private var bucketArn: Output<String>? = null

    private var bufferingInterval: Output<Int>? = null

    private var bufferingSize: Output<Int>? = null

    private var cloudwatchLoggingOptions:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgs>? = null

    private var compressionFormat: Output<String>? = null

    private var dataFormatConversionConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs>? =
        null

    private var dynamicPartitioningConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs>? =
        null

    private var errorOutputPrefix: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var prefix: Output<String>? = null

    private var processingConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs>? = null

    private var roleArn: Output<String>? = null

    private var s3BackupConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgs>? = null

    private var s3BackupMode: Output<String>? = null

    /**
     * @param value The ARN of the S3 bucket
     */
    @JvmName("wiksasrhbnbcwnch")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("opmgyciohyqqqbsw")
    public suspend fun bufferingInterval(`value`: Output<Int>) {
        this.bufferingInterval = value
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("beqnfcxsicybwadf")
    public suspend fun bufferingSize(`value`: Output<Int>) {
        this.bufferingSize = value
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("uwlouxffyejrrrdb")
    public suspend
    fun cloudwatchLoggingOptions(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgs>) {
        this.cloudwatchLoggingOptions = value
    }

    /**
     * @param value The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
     */
    @JvmName("xwmlusddbamygmyc")
    public suspend fun compressionFormat(`value`: Output<String>) {
        this.compressionFormat = value
    }

    /**
     * @param value Nested argument for the serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3. More details given below.
     */
    @JvmName("lshueaffqqjkbcxr")
    public suspend
    fun dataFormatConversionConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs>) {
        this.dataFormatConversionConfiguration = value
    }

    /**
     * @param value The configuration for dynamic partitioning. See Dynamic Partitioning Configuration below for more details. Required when using dynamic partitioning.
     */
    @JvmName("uacerpcvjudbhsqo")
    public suspend
    fun dynamicPartitioningConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs>) {
        this.dynamicPartitioningConfiguration = value
    }

    /**
     * @param value Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    @JvmName("hbodgmeikogblxhn")
    public suspend fun errorOutputPrefix(`value`: Output<String>) {
        this.errorOutputPrefix = value
    }

    /**
     * @param value Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
     * be used.
     */
    @JvmName("ktvkjdlqtojxnpxv")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
     */
    @JvmName("hrbwvofxnvbkmcls")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("nmyoflxvinhhojmw")
    public suspend
    fun processingConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs>) {
        this.processingConfiguration = value
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("uemlliydyclsprxq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("puaydbjtjvfneqlb")
    public suspend
    fun s3BackupConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgs>) {
        this.s3BackupConfiguration = value
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("slowqnemkicvenrl")
    public suspend fun s3BackupMode(`value`: Output<String>) {
        this.s3BackupMode = value
    }

    /**
     * @param value The ARN of the S3 bucket
     */
    @JvmName("jhdonuxuryevhkjh")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value Buffer incoming data for the specified period of time, in seconds between 60 to 900, before delivering it to the destination.  The default value is 300s.
     */
    @JvmName("ugmcvycobpmcwecv")
    public suspend fun bufferingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingInterval = mapped
    }

    /**
     * @param value Buffer incoming data to the specified size, in MBs between 1 to 100, before delivering it to the destination.  The default value is 5MB.
     */
    @JvmName("mdyaagyhtglkcqbs")
    public suspend fun bufferingSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferingSize = mapped
    }

    /**
     * @param value The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("ajdqtsqlwjglcfmp")
    public suspend
    fun cloudwatchLoggingOptions(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param argument The CloudWatch Logging Options for the delivery stream. More details are given below
     */
    @JvmName("hmwahvuvcpnyfevc")
    public suspend
    fun cloudwatchLoggingOptions(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationCloudwatchLoggingOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLoggingOptions = mapped
    }

    /**
     * @param value The compression format. If no value is specified, the default is `UNCOMPRESSED`. Other supported values are `GZIP`, `ZIP`, `Snappy`, & `HADOOP_SNAPPY`.
     */
    @JvmName("heeosvycrwklbjny")
    public suspend fun compressionFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compressionFormat = mapped
    }

    /**
     * @param value Nested argument for the serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3. More details given below.
     */
    @JvmName("qkhdsoidskwgiioi")
    public suspend
    fun dataFormatConversionConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormatConversionConfiguration = mapped
    }

    /**
     * @param argument Nested argument for the serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3. More details given below.
     */
    @JvmName("pqaliaybvcgcwtcn")
    public suspend
    fun dataFormatConversionConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataFormatConversionConfiguration = mapped
    }

    /**
     * @param value The configuration for dynamic partitioning. See Dynamic Partitioning Configuration below for more details. Required when using dynamic partitioning.
     */
    @JvmName("hlkfyldekwhwnppb")
    public suspend
    fun dynamicPartitioningConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicPartitioningConfiguration = mapped
    }

    /**
     * @param argument The configuration for dynamic partitioning. See Dynamic Partitioning Configuration below for more details. Required when using dynamic partitioning.
     */
    @JvmName("hvbdpybgdmpodeum")
    public suspend
    fun dynamicPartitioningConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dynamicPartitioningConfiguration = mapped
    }

    /**
     * @param value Prefix added to failed records before writing them to S3. Not currently supported for `redshift` destination. This prefix appears immediately following the bucket name. For information about how to specify this prefix, see [Custom Prefixes for Amazon S3 Objects](https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
     */
    @JvmName("rhirlipwjnmtvuqu")
    public suspend fun errorOutputPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorOutputPrefix = mapped
    }

    /**
     * @param value Specifies the KMS key ARN the stream will use to encrypt data. If not set, no encryption will
     * be used.
     */
    @JvmName("fuyttotdmxoxtxit")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered S3 files. You can specify an extra prefix to be added in front of the time format prefix. Note that if the prefix ends with a slash, it appears as a folder in the S3 bucket
     */
    @JvmName("goibymoqdqtcjeug")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The data processing configuration.  More details are given below.
     */
    @JvmName("xpbutgwkjcydgyir")
    public suspend
    fun processingConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingConfiguration = mapped
    }

    /**
     * @param argument The data processing configuration.  More details are given below.
     */
    @JvmName("sfmcelulxrttnjkv")
    public suspend
    fun processingConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationProcessingConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.processingConfiguration = mapped
    }

    /**
     * @param value The ARN of the role used to access the Amazon MSK cluster.
     */
    @JvmName("qriwbkgempnibblw")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("qppcigjourvltbex")
    public suspend
    fun s3BackupConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupConfiguration = mapped
    }

    /**
     * @param argument The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
     */
    @JvmName("hggddhttpbvmtklu")
    public suspend
    fun s3BackupConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationS3BackupConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3BackupConfiguration = mapped
    }

    /**
     * @param value Defines how documents should be delivered to Amazon S3.  Valid values are `FailedDocumentsOnly` and `AllDocuments`.  Default value is `FailedDocumentsOnly`.
     */
    @JvmName("ixinvapfkibhosrs")
    public suspend fun s3BackupMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3BackupMode = mapped
    }

    internal fun build(): FirehoseDeliveryStreamExtendedS3ConfigurationArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationArgs(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            bufferingInterval = bufferingInterval,
            bufferingSize = bufferingSize,
            cloudwatchLoggingOptions = cloudwatchLoggingOptions,
            compressionFormat = compressionFormat,
            dataFormatConversionConfiguration = dataFormatConversionConfiguration,
            dynamicPartitioningConfiguration = dynamicPartitioningConfiguration,
            errorOutputPrefix = errorOutputPrefix,
            kmsKeyArn = kmsKeyArn,
            prefix = prefix,
            processingConfiguration = processingConfiguration,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            s3BackupConfiguration = s3BackupConfiguration,
            s3BackupMode = s3BackupMode,
        )
}
