@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Defaults to `true`. Set it to `false` if you want to disable format conversion while preserving the configuration details.
 * @property inputFormatConfiguration Nested argument that specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. More details below.
 * @property outputFormatConfiguration Nested argument that specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. More details below.
 * @property schemaConfiguration Nested argument that specifies the AWS Glue Data Catalog table that contains the column information. More details below.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val inputFormatConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgs>,
    public val outputFormatConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgs>,
    public val schemaConfiguration:
    Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .inputFormatConfiguration(
                inputFormatConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputFormatConfiguration(
                outputFormatConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schemaConfiguration(
                schemaConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var inputFormatConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgs>? =
        null

    private var outputFormatConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgs>? =
        null

    private var schemaConfiguration:
        Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs>? =
        null

    /**
     * @param value Defaults to `true`. Set it to `false` if you want to disable format conversion while preserving the configuration details.
     */
    @JvmName("mofqfhfwbopbthlx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Nested argument that specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. More details below.
     */
    @JvmName("ixumeidkugaanqpv")
    public suspend
    fun inputFormatConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgs>) {
        this.inputFormatConfiguration = value
    }

    /**
     * @param value Nested argument that specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. More details below.
     */
    @JvmName("ugcegocgemlnyicl")
    public suspend
    fun outputFormatConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgs>) {
        this.outputFormatConfiguration = value
    }

    /**
     * @param value Nested argument that specifies the AWS Glue Data Catalog table that contains the column information. More details below.
     */
    @JvmName("jceubgcigskltxux")
    public suspend
    fun schemaConfiguration(`value`: Output<FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs>) {
        this.schemaConfiguration = value
    }

    /**
     * @param value Defaults to `true`. Set it to `false` if you want to disable format conversion while preserving the configuration details.
     */
    @JvmName("dfgpndjhwjpydgjg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Nested argument that specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. More details below.
     */
    @JvmName("fdyaskhfgtpluvdj")
    public suspend
    fun inputFormatConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputFormatConfiguration = mapped
    }

    /**
     * @param argument Nested argument that specifies the deserializer that you want Kinesis Data Firehose to use to convert the format of your data from JSON. More details below.
     */
    @JvmName("vwlbypxwqxydwpmx")
    public suspend
    fun inputFormatConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inputFormatConfiguration = mapped
    }

    /**
     * @param value Nested argument that specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. More details below.
     */
    @JvmName("clamexybyelwksrx")
    public suspend
    fun outputFormatConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputFormatConfiguration = mapped
    }

    /**
     * @param argument Nested argument that specifies the serializer that you want Kinesis Data Firehose to use to convert the format of your data to the Parquet or ORC format. More details below.
     */
    @JvmName("vbvrdtqjrhudnoxn")
    public suspend
    fun outputFormatConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.outputFormatConfiguration = mapped
    }

    /**
     * @param value Nested argument that specifies the AWS Glue Data Catalog table that contains the column information. More details below.
     */
    @JvmName("pyfhgukpmqgeipai")
    public suspend
    fun schemaConfiguration(`value`: FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaConfiguration = mapped
    }

    /**
     * @param argument Nested argument that specifies the AWS Glue Data Catalog table that contains the column information. More details below.
     */
    @JvmName("esypnoyfqsqflfgd")
    public suspend
    fun schemaConfiguration(argument: suspend FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.schemaConfiguration = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationArgs(
            enabled = enabled,
            inputFormatConfiguration = inputFormatConfiguration ?: throw
                PulumiNullFieldException("inputFormatConfiguration"),
            outputFormatConfiguration = outputFormatConfiguration ?: throw
                PulumiNullFieldException("outputFormatConfiguration"),
            schemaConfiguration = schemaConfiguration ?: throw PulumiNullFieldException("schemaConfiguration"),
        )
}
