@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property caseInsensitive When set to true, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
 * @property columnToJsonKeyMappings A map of column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, timestamp is a Hive keyword. If you have a JSON key named timestamp, set this parameter to `{ ts = "timestamp" }` to map this key to a column named ts.
 * @property convertDotsInJsonKeysToUnderscores When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option. Defaults to `false`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs(
    public val caseInsensitive: Output<Boolean>? = null,
    public val columnToJsonKeyMappings: Output<Map<String, String>>? = null,
    public val convertDotsInJsonKeysToUnderscores: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs.builder()
            .caseInsensitive(caseInsensitive?.applyValue({ args0 -> args0 }))
            .columnToJsonKeyMappings(
                columnToJsonKeyMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .convertDotsInJsonKeysToUnderscores(
                convertDotsInJsonKeysToUnderscores?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgsBuilder
internal constructor() {
    private var caseInsensitive: Output<Boolean>? = null

    private var columnToJsonKeyMappings: Output<Map<String, String>>? = null

    private var convertDotsInJsonKeysToUnderscores: Output<Boolean>? = null

    /**
     * @param value When set to true, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
     */
    @JvmName("dpfbslquyginmugx")
    public suspend fun caseInsensitive(`value`: Output<Boolean>) {
        this.caseInsensitive = value
    }

    /**
     * @param value A map of column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, timestamp is a Hive keyword. If you have a JSON key named timestamp, set this parameter to `{ ts = "timestamp" }` to map this key to a column named ts.
     */
    @JvmName("uyttfptmntgfscvp")
    public suspend fun columnToJsonKeyMappings(`value`: Output<Map<String, String>>) {
        this.columnToJsonKeyMappings = value
    }

    /**
     * @param value When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option. Defaults to `false`.
     */
    @JvmName("hukxwxqeivpkgdhw")
    public suspend fun convertDotsInJsonKeysToUnderscores(`value`: Output<Boolean>) {
        this.convertDotsInJsonKeysToUnderscores = value
    }

    /**
     * @param value When set to true, which is the default, Kinesis Data Firehose converts JSON keys to lowercase before deserializing them.
     */
    @JvmName("rjaxgahayffqalai")
    public suspend fun caseInsensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseInsensitive = mapped
    }

    /**
     * @param value A map of column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, timestamp is a Hive keyword. If you have a JSON key named timestamp, set this parameter to `{ ts = "timestamp" }` to map this key to a column named ts.
     */
    @JvmName("fsunkovjrwlbjxwn")
    public suspend fun columnToJsonKeyMappings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnToJsonKeyMappings = mapped
    }

    /**
     * @param values A map of column names to JSON keys that aren't identical to the column names. This is useful when the JSON contains keys that are Hive keywords. For example, timestamp is a Hive keyword. If you have a JSON key named timestamp, set this parameter to `{ ts = "timestamp" }` to map this key to a column named ts.
     */
    @JvmName("xfltrajhwufqalmh")
    public fun columnToJsonKeyMappings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnToJsonKeyMappings = mapped
    }

    /**
     * @param value When set to `true`, specifies that the names of the keys include dots and that you want Kinesis Data Firehose to replace them with underscores. This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option. Defaults to `false`.
     */
    @JvmName("mgfkusnfdhfxxpco")
    public suspend fun convertDotsInJsonKeysToUnderscores(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.convertDotsInJsonKeysToUnderscores = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationInputFormatConfigurationDeserializerOpenXJsonSerDeArgs(
            caseInsensitive = caseInsensitive,
            columnToJsonKeyMappings = columnToJsonKeyMappings,
            convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores,
        )
}
