@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property blockSizeBytes The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
 * @property bloomFilterColumns A list of column names for which you want Kinesis Data Firehose to create bloom filters.
 * @property bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is `0.05`, the minimum is `0`, and the maximum is `1`.
 * @property compression The compression code to use over data blocks. The default is `SNAPPY`.
 * @property dictionaryKeyThreshold A float that represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to `1`.
 * @property enablePadding Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
 * @property formatVersion The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
 * @property paddingTolerance A float between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is `0.05`, which means 5 percent of stripe size. For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task. Kinesis Data Firehose ignores this parameter when `enable_padding` is `false`.
 * @property rowIndexStride The number of rows between index entries. The default is `10000` and the minimum is `1000`.
 * @property stripeSizeBytes The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs(
    public val blockSizeBytes: Output<Int>? = null,
    public val bloomFilterColumns: Output<List<String>>? = null,
    public val bloomFilterFalsePositiveProbability: Output<Double>? = null,
    public val compression: Output<String>? = null,
    public val dictionaryKeyThreshold: Output<Double>? = null,
    public val enablePadding: Output<Boolean>? = null,
    public val formatVersion: Output<String>? = null,
    public val paddingTolerance: Output<Double>? = null,
    public val rowIndexStride: Output<Int>? = null,
    public val stripeSizeBytes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs.builder()
            .blockSizeBytes(blockSizeBytes?.applyValue({ args0 -> args0 }))
            .bloomFilterColumns(bloomFilterColumns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bloomFilterFalsePositiveProbability(
                bloomFilterFalsePositiveProbability?.applyValue({ args0 ->
                    args0
                }),
            )
            .compression(compression?.applyValue({ args0 -> args0 }))
            .dictionaryKeyThreshold(dictionaryKeyThreshold?.applyValue({ args0 -> args0 }))
            .enablePadding(enablePadding?.applyValue({ args0 -> args0 }))
            .formatVersion(formatVersion?.applyValue({ args0 -> args0 }))
            .paddingTolerance(paddingTolerance?.applyValue({ args0 -> args0 }))
            .rowIndexStride(rowIndexStride?.applyValue({ args0 -> args0 }))
            .stripeSizeBytes(stripeSizeBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgsBuilder
internal constructor() {
    private var blockSizeBytes: Output<Int>? = null

    private var bloomFilterColumns: Output<List<String>>? = null

    private var bloomFilterFalsePositiveProbability: Output<Double>? = null

    private var compression: Output<String>? = null

    private var dictionaryKeyThreshold: Output<Double>? = null

    private var enablePadding: Output<Boolean>? = null

    private var formatVersion: Output<String>? = null

    private var paddingTolerance: Output<Double>? = null

    private var rowIndexStride: Output<Int>? = null

    private var stripeSizeBytes: Output<Int>? = null

    /**
     * @param value The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
     */
    @JvmName("njsticbxmfgrmtbl")
    public suspend fun blockSizeBytes(`value`: Output<Int>) {
        this.blockSizeBytes = value
    }

    /**
     * @param value A list of column names for which you want Kinesis Data Firehose to create bloom filters.
     */
    @JvmName("yyxbolqvprqheplr")
    public suspend fun bloomFilterColumns(`value`: Output<List<String>>) {
        this.bloomFilterColumns = value
    }

    @JvmName("loespveefpynntah")
    public suspend fun bloomFilterColumns(vararg values: Output<String>) {
        this.bloomFilterColumns = Output.all(values.asList())
    }

    /**
     * @param values A list of column names for which you want Kinesis Data Firehose to create bloom filters.
     */
    @JvmName("puwcinjwbpnslhip")
    public suspend fun bloomFilterColumns(values: List<Output<String>>) {
        this.bloomFilterColumns = Output.all(values)
    }

    /**
     * @param value The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is `0.05`, the minimum is `0`, and the maximum is `1`.
     */
    @JvmName("jptmjjihxyqccpta")
    public suspend fun bloomFilterFalsePositiveProbability(`value`: Output<Double>) {
        this.bloomFilterFalsePositiveProbability = value
    }

    /**
     * @param value The compression code to use over data blocks. The default is `SNAPPY`.
     */
    @JvmName("aejhrhowojmmgqvt")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value A float that represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to `1`.
     */
    @JvmName("eybiiemjhtgnsomr")
    public suspend fun dictionaryKeyThreshold(`value`: Output<Double>) {
        this.dictionaryKeyThreshold = value
    }

    /**
     * @param value Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
     */
    @JvmName("auxpifrwpqlygtim")
    public suspend fun enablePadding(`value`: Output<Boolean>) {
        this.enablePadding = value
    }

    /**
     * @param value The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
     */
    @JvmName("tjgmvrpybfhtmcor")
    public suspend fun formatVersion(`value`: Output<String>) {
        this.formatVersion = value
    }

    /**
     * @param value A float between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is `0.05`, which means 5 percent of stripe size. For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task. Kinesis Data Firehose ignores this parameter when `enable_padding` is `false`.
     */
    @JvmName("dwarcjlaahyhnqap")
    public suspend fun paddingTolerance(`value`: Output<Double>) {
        this.paddingTolerance = value
    }

    /**
     * @param value The number of rows between index entries. The default is `10000` and the minimum is `1000`.
     */
    @JvmName("ejlliltsxgyorjxk")
    public suspend fun rowIndexStride(`value`: Output<Int>) {
        this.rowIndexStride = value
    }

    /**
     * @param value The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
     */
    @JvmName("rpawxeeulfjonqte")
    public suspend fun stripeSizeBytes(`value`: Output<Int>) {
        this.stripeSizeBytes = value
    }

    /**
     * @param value The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
     */
    @JvmName("dbrhdiqkjljogrik")
    public suspend fun blockSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSizeBytes = mapped
    }

    /**
     * @param value A list of column names for which you want Kinesis Data Firehose to create bloom filters.
     */
    @JvmName("vtcvnnnfqnnwskmb")
    public suspend fun bloomFilterColumns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bloomFilterColumns = mapped
    }

    /**
     * @param values A list of column names for which you want Kinesis Data Firehose to create bloom filters.
     */
    @JvmName("vdubuojwrakgfydd")
    public suspend fun bloomFilterColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bloomFilterColumns = mapped
    }

    /**
     * @param value The Bloom filter false positive probability (FPP). The lower the FPP, the bigger the Bloom filter. The default value is `0.05`, the minimum is `0`, and the maximum is `1`.
     */
    @JvmName("shtqhceecaahcrqc")
    public suspend fun bloomFilterFalsePositiveProbability(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bloomFilterFalsePositiveProbability = mapped
    }

    /**
     * @param value The compression code to use over data blocks. The default is `SNAPPY`.
     */
    @JvmName("onwdeekdkkaiumgh")
    public suspend fun compression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value A float that represents the fraction of the total number of non-null rows. To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to `1`.
     */
    @JvmName("kdmwyhkoaracugow")
    public suspend fun dictionaryKeyThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dictionaryKeyThreshold = mapped
    }

    /**
     * @param value Set this to `true` to indicate that you want stripes to be padded to the HDFS block boundaries. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `false`.
     */
    @JvmName("fiqbmvytdvigdoct")
    public suspend fun enablePadding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePadding = mapped
    }

    /**
     * @param value The version of the file to write. The possible values are `V0_11` and `V0_12`. The default is `V0_12`.
     */
    @JvmName("kbidrmfhiupjpyfd")
    public suspend fun formatVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatVersion = mapped
    }

    /**
     * @param value A float between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size. The default value is `0.05`, which means 5 percent of stripe size. For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task. Kinesis Data Firehose ignores this parameter when `enable_padding` is `false`.
     */
    @JvmName("epklpshrekkvptkd")
    public suspend fun paddingTolerance(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paddingTolerance = mapped
    }

    /**
     * @param value The number of rows between index entries. The default is `10000` and the minimum is `1000`.
     */
    @JvmName("mevxvdqmmeudspgh")
    public suspend fun rowIndexStride(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rowIndexStride = mapped
    }

    /**
     * @param value The number of bytes in each stripe. The default is 64 MiB and the minimum is 8 MiB.
     */
    @JvmName("ulgjketqnmfwtspn")
    public suspend fun stripeSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stripeSizeBytes = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerOrcSerDeArgs(
            blockSizeBytes = blockSizeBytes,
            bloomFilterColumns = bloomFilterColumns,
            bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability,
            compression = compression,
            dictionaryKeyThreshold = dictionaryKeyThreshold,
            enablePadding = enablePadding,
            formatVersion = formatVersion,
            paddingTolerance = paddingTolerance,
            rowIndexStride = rowIndexStride,
            stripeSizeBytes = stripeSizeBytes,
        )
}
