@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blockSizeBytes The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
 * @property compression The compression code to use over data blocks. The possible values are `UNCOMPRESSED`, `SNAPPY`, and `GZIP`, with the default being `SNAPPY`. Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
 * @property enableDictionaryCompression Indicates whether to enable dictionary compression.
 * @property maxPaddingBytes The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `0`.
 * @property pageSizeBytes The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
 * @property writerVersion Indicates the version of row format to output. The possible values are `V1` and `V2`. The default is `V1`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs(
    public val blockSizeBytes: Output<Int>? = null,
    public val compression: Output<String>? = null,
    public val enableDictionaryCompression: Output<Boolean>? = null,
    public val maxPaddingBytes: Output<Int>? = null,
    public val pageSizeBytes: Output<Int>? = null,
    public val writerVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs.builder()
            .blockSizeBytes(blockSizeBytes?.applyValue({ args0 -> args0 }))
            .compression(compression?.applyValue({ args0 -> args0 }))
            .enableDictionaryCompression(enableDictionaryCompression?.applyValue({ args0 -> args0 }))
            .maxPaddingBytes(maxPaddingBytes?.applyValue({ args0 -> args0 }))
            .pageSizeBytes(pageSizeBytes?.applyValue({ args0 -> args0 }))
            .writerVersion(writerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgsBuilder
internal constructor() {
    private var blockSizeBytes: Output<Int>? = null

    private var compression: Output<String>? = null

    private var enableDictionaryCompression: Output<Boolean>? = null

    private var maxPaddingBytes: Output<Int>? = null

    private var pageSizeBytes: Output<Int>? = null

    private var writerVersion: Output<String>? = null

    /**
     * @param value The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
     */
    @JvmName("egkkhvxkonwopicv")
    public suspend fun blockSizeBytes(`value`: Output<Int>) {
        this.blockSizeBytes = value
    }

    /**
     * @param value The compression code to use over data blocks. The possible values are `UNCOMPRESSED`, `SNAPPY`, and `GZIP`, with the default being `SNAPPY`. Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
     */
    @JvmName("anwvbsrwhbsrwwqi")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value Indicates whether to enable dictionary compression.
     */
    @JvmName("cdhfpksunffaqmgc")
    public suspend fun enableDictionaryCompression(`value`: Output<Boolean>) {
        this.enableDictionaryCompression = value
    }

    /**
     * @param value The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `0`.
     */
    @JvmName("wqdmfyuvroaunbgw")
    public suspend fun maxPaddingBytes(`value`: Output<Int>) {
        this.maxPaddingBytes = value
    }

    /**
     * @param value The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
     */
    @JvmName("kxfrabrwvharotma")
    public suspend fun pageSizeBytes(`value`: Output<Int>) {
        this.pageSizeBytes = value
    }

    /**
     * @param value Indicates the version of row format to output. The possible values are `V1` and `V2`. The default is `V1`.
     */
    @JvmName("meywndxjrvgwoamx")
    public suspend fun writerVersion(`value`: Output<String>) {
        this.writerVersion = value
    }

    /**
     * @param value The Hadoop Distributed File System (HDFS) block size. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value for padding calculations.
     */
    @JvmName("cmgfbnhvctciylot")
    public suspend fun blockSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockSizeBytes = mapped
    }

    /**
     * @param value The compression code to use over data blocks. The possible values are `UNCOMPRESSED`, `SNAPPY`, and `GZIP`, with the default being `SNAPPY`. Use `SNAPPY` for higher decompression speed. Use `GZIP` if the compression ratio is more important than speed.
     */
    @JvmName("qjibmtjxiyjaujsy")
    public suspend fun compression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value Indicates whether to enable dictionary compression.
     */
    @JvmName("ybwpyqjtjxdgftrk")
    public suspend fun enableDictionaryCompression(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDictionaryCompression = mapped
    }

    /**
     * @param value The maximum amount of padding to apply. This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is `0`.
     */
    @JvmName("giefqpxcpdibbtxw")
    public suspend fun maxPaddingBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPaddingBytes = mapped
    }

    /**
     * @param value The Parquet page size. Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
     */
    @JvmName("rycpikgreqmleois")
    public suspend fun pageSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageSizeBytes = mapped
    }

    /**
     * @param value Indicates the version of row format to output. The possible values are `V1` and `V2`. The default is `V1`.
     */
    @JvmName("rblhqctwhxcnujna")
    public suspend fun writerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writerVersion = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationOutputFormatConfigurationSerializerParquetSerDeArgs(
            blockSizeBytes = blockSizeBytes,
            compression = compression,
            enableDictionaryCompression = enableDictionaryCompression,
            maxPaddingBytes = maxPaddingBytes,
            pageSizeBytes = pageSizeBytes,
            writerVersion = writerVersion,
        )
}
