@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogId The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
 * @property databaseName Specifies the name of the AWS Glue database that contains the schema for the output data.
 * @property region If you don't specify an AWS Region, the default is the current region.
 * @property roleArn The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
 * @property tableName Specifies the AWS Glue table that contains the column information that constitutes your data schema.
 * @property versionId Specifies the table version for the output data schema. Defaults to `LATEST`.
 */
public data class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs(
    public val catalogId: Output<String>? = null,
    public val databaseName: Output<String>,
    public val region: Output<String>? = null,
    public val roleArn: Output<String>,
    public val tableName: Output<String>,
    public val versionId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs.builder()
            .catalogId(catalogId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .tableName(tableName.applyValue({ args0 -> args0 }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgsBuilder
internal constructor() {
    private var catalogId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var region: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tableName: Output<String>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
     */
    @JvmName("sawumtesyhtvkneq")
    public suspend fun catalogId(`value`: Output<String>) {
        this.catalogId = value
    }

    /**
     * @param value Specifies the name of the AWS Glue database that contains the schema for the output data.
     */
    @JvmName("gipexbskylaejvqh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value If you don't specify an AWS Region, the default is the current region.
     */
    @JvmName("djkwkoxhcrxxieyy")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
     */
    @JvmName("fraxlgdnssaramkw")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Specifies the AWS Glue table that contains the column information that constitutes your data schema.
     */
    @JvmName("oykewexgcsqouasb")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Specifies the table version for the output data schema. Defaults to `LATEST`.
     */
    @JvmName("lleigcdkubnvtvww")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value The ID of the AWS Glue Data Catalog. If you don't supply this, the AWS account ID is used by default.
     */
    @JvmName("yxputylkifkuepnf")
    public suspend fun catalogId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogId = mapped
    }

    /**
     * @param value Specifies the name of the AWS Glue database that contains the schema for the output data.
     */
    @JvmName("fqjeisxmgaudeegg")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value If you don't specify an AWS Region, the default is the current region.
     */
    @JvmName("rhtenahmioxfhnoc")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The role that Kinesis Data Firehose can use to access AWS Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
     */
    @JvmName("jtuflquijaiftipq")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Specifies the AWS Glue table that contains the column information that constitutes your data schema.
     */
    @JvmName("ddtcjiegiagnesbb")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Specifies the table version for the output data schema. Defaults to `LATEST`.
     */
    @JvmName("tkepvjratbgnhmmm")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDataFormatConversionConfigurationSchemaConfigurationArgs(
            catalogId = catalogId,
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            region = region,
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            tableName = tableName ?: throw PulumiNullFieldException("tableName"),
            versionId = versionId,
        )
}
