@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.inputs

import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables or disables dynamic partitioning. Defaults to `false`.
 * @property retryDuration Total amount of seconds Firehose spends on retries. Valid values between 0 and 7200. Default is 300.
 * > **NOTE:** You can enable dynamic partitioning only when you create a new delivery stream. Once you enable dynamic partitioning on a delivery stream, it cannot be disabled on this delivery stream. Therefore, the provider will recreate the resource whenever dynamic partitioning is enabled or disabled.
 */
public data class FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val retryDuration: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs =
        com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .retryDuration(retryDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs].
 */
@PulumiTagMarker
public class
FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgsBuilder
internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var retryDuration: Output<Int>? = null

    /**
     * @param value Enables or disables dynamic partitioning. Defaults to `false`.
     */
    @JvmName("nxdgenyfwlbblplh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Total amount of seconds Firehose spends on retries. Valid values between 0 and 7200. Default is 300.
     * > **NOTE:** You can enable dynamic partitioning only when you create a new delivery stream. Once you enable dynamic partitioning on a delivery stream, it cannot be disabled on this delivery stream. Therefore, the provider will recreate the resource whenever dynamic partitioning is enabled or disabled.
     */
    @JvmName("hcfcnmwoildyikyx")
    public suspend fun retryDuration(`value`: Output<Int>) {
        this.retryDuration = value
    }

    /**
     * @param value Enables or disables dynamic partitioning. Defaults to `false`.
     */
    @JvmName("nqcegihoicfjrlcl")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Total amount of seconds Firehose spends on retries. Valid values between 0 and 7200. Default is 300.
     * > **NOTE:** You can enable dynamic partitioning only when you create a new delivery stream. Once you enable dynamic partitioning on a delivery stream, it cannot be disabled on this delivery stream. Therefore, the provider will recreate the resource whenever dynamic partitioning is enabled or disabled.
     */
    @JvmName("axoqemigxbepbbvu")
    public suspend fun retryDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryDuration = mapped
    }

    internal fun build():
        FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs =
        FirehoseDeliveryStreamExtendedS3ConfigurationDynamicPartitioningConfigurationArgs(
            enabled = enabled,
            retryDuration = retryDuration,
        )
}
